/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.ui.launch;

import com.google.common.collect.Lists;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.dependability.ml.sensitivity.api.MLSensitivityAnalyser;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;

public class MLSensitivityLaunchTab
extends AbstractLaunchConfigurationTab {
    private static final String NAME = "ML Sensitivity Analysis";
    private static final String NONE_ITEM = "None";
    private static final String[] RESTRICTIONS = new String[]{"*.*"};
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MLSensitivityLaunchTab.this.setDirty(true);
            MLSensitivityLaunchTab.this.updateLaunchConfigurationDialog();
        }
    };
    private Text modelLocationText;
    private Text trainingDataLocationText;
    private Text sensModelStoringLocation;
    private Combo supportedModelsCombobox;
    private Combo strategyCombobox;
    private List<Button> propertyCheckboxes;

    public void createControl(Composite parent) {
        Composite container = this.createRootContainer(parent);
        this.createModelLocationText(container);
        this.createTrainDataLocationText(container);
        this.createMLSupportedModelsGroup(container);
        this.createSensitivityPropertyGroup(container);
        this.createStrategyGroup(container);
    }

    private Composite createRootContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        return container;
    }

    private void createModelLocationText(Composite container) {
        this.modelLocationText = new Text(container, 2052);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"ML model location", (String[])RESTRICTIONS, (Text)this.modelLocationText, (Shell)this.getShell(), (String)"http://127.0.0.1:8080");
    }

    private void createTrainDataLocationText(Composite container) {
        this.trainingDataLocationText = new Text(container, 2052);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"ML training data location", (String[])RESTRICTIONS, (Text)this.trainingDataLocationText, (Shell)this.getShell(), (String)"");
    }

    private void createMLSupportedModelsGroup(Composite container) {
        Group mlModelsGroup = new Group(container, 0);
        mlModelsGroup.setText("ML model selection for sensitivity analysis");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)mlModelsGroup);
        Label mlModelLabel = new Label((Composite)mlModelsGroup, 0);
        mlModelLabel.setText("Supported models:");
        GridDataFactory.swtDefaults().applyTo((Control)mlModelLabel);
        this.supportedModelsCombobox = new Combo((Composite)mlModelsGroup, 8);
        this.supportedModelsCombobox.setItems(this.getAnalysableModelNames());
        this.supportedModelsCombobox.setSize(400, 200);
    }

    private void createSensitivityPropertyGroup(Composite container) {
        Group sensitivityPropertiesGroup = new Group(container, 0);
        sensitivityPropertiesGroup.setText("Analysable Sensitivity Properties");
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)sensitivityPropertiesGroup);
        this.propertyCheckboxes = Lists.newArrayList();
        for (PropertyMeasure each : MLSensitivityAnalyser.getAnalysablePropertyMeasures()) {
            Button propButton = new Button((Composite)sensitivityPropertiesGroup, 32);
            propButton.setSelection(false);
            propButton.setText(each.getName());
            this.propertyCheckboxes.add(propButton);
        }
    }

    private void createStrategyGroup(Composite container) {
        Group strategyGroup = new Group(container, 0);
        strategyGroup.setText("Sensitivity Analysis Strategy");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)strategyGroup);
        Label strategyLabel = new Label((Composite)strategyGroup, 0);
        strategyLabel.setText("Supported strategies:");
        GridDataFactory.swtDefaults().applyTo((Control)strategyLabel);
        this.strategyCombobox = new Combo((Composite)strategyGroup, 8);
        this.strategyCombobox.setItems(this.getAnalysisStrategyNames());
        this.strategyCombobox.setSize(400, 200);
        this.sensModelStoringLocation = new Text(container, 2052);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"Storing location of sensitivity model", (String[])RESTRICTIONS, (Text)this.sensModelStoringLocation, (Shell)this.getShell(), (String)"org.palladiosimulator.dependability.ml.ui.sensmodel");
    }

    private String[] getAnalysisStrategyNames() {
        return this.enrichWithNoneItem(MLSensitivityAnalyser.getAnalysisStrategyNames());
    }

    private String[] getAnalysableModelNames() {
        return this.enrichWithNoneItem(MLSensitivityAnalyser.getAnalysableModelNames());
    }

    private String[] enrichWithNoneItem(Set<String> items) {
        String[] enrichedItems = new String[items.size() + 1];
        enrichedItems[0] = NONE_ITEM;
        ArrayList itemList = Lists.newArrayList(items);
        int i = 0;
        while (i < itemList.size()) {
            enrichedItems[i + 1] = (String)itemList.get(i);
            ++i;
        }
        return enrichedItems;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.supportedModelsCombobox.select(0);
        this.strategyCombobox.select(0);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.palladiosimulator.dependability.ml.ui.modelurl", this.modelLocationText.getText());
        configuration.setAttribute("org.palladiosimulator.dependability.ml.ui.traindata", this.trainingDataLocationText.getText());
        configuration.setAttribute("org.palladiosimulator.dependability.ml.ui.sensmodel", this.sensModelStoringLocation.getText());
        configuration.setAttribute("org.palladiosimulator.dependability.ml.ui.strategy", this.strategyCombobox.getItem(this.strategyCombobox.getSelectionIndex()));
        configuration.setAttribute("org.palladiosimulator.dependability.ml.ui.model", this.supportedModelsCombobox.getItem(this.supportedModelsCombobox.getSelectionIndex()));
        for (Button each : this.propertyCheckboxes) {
            if (!each.getSelection()) continue;
            String attr = "org.palladiosimulator.dependability.ml.ui.property".concat(each.getText());
            configuration.setAttribute(attr, each.getText());
        }
    }

    public String getName() {
        return NAME;
    }
}

