/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.model.access;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.palladiosimulator.dependability.ml.exception.DependableMLException;
import org.palladiosimulator.dependability.ml.model.InputData;
import org.palladiosimulator.dependability.ml.model.OutputData;
import org.palladiosimulator.dependability.ml.model.access.TrainedModelAccessor;

public class HttpModelAccessor
implements TrainedModelAccessor<InputData, OutputData> {
    private static int HTTP_OK = 200;
    private static final String PREDICTION_ROUTE = "/predict";
    private static final String SUPPORTED_SCHEME = "http";
    private static final int TIME_OUT_DURATION = 2;
    private URI remoteModelURI = null;
    private final HttpClient client = HttpClient.newHttpClient();
    private final Function<String, List<OutputData>> jsonParser;

    public HttpModelAccessor(Function<String, List<OutputData>> jsonParser) {
        this.jsonParser = Objects.nonNull(jsonParser) ? jsonParser : this.defaultJsonParser();
    }

    public HttpModelAccessor() {
        this(null);
    }

    private Function<String, List<OutputData>> defaultJsonParser() {
        return json -> {
            Object[] outData = (OutputData[])new Gson().fromJson(json, OutputData[].class);
            return Lists.newArrayList((Object[])outData);
        };
    }

    @Override
    public boolean canAccess(URI modelURI) {
        return modelURI.getScheme().equals(SUPPORTED_SCHEME);
    }

    @Override
    public void load(URI modelURI) {
        this.remoteModelURI = this.adjustQueryUri(modelURI);
    }

    @Override
    public List<OutputData> query(InputData inputData) {
        Objects.requireNonNull(this.remoteModelURI, "The model must be loaded first.");
        HttpRequest request = HttpRequest.newBuilder(this.remoteModelURI).header("Content-Type", "application/json").timeout(Duration.ofMinutes(2L)).POST(HttpRequest.BodyPublishers.ofString(this.jsonify(inputData))).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != HTTP_OK) {
                DependableMLException.throwWithMessage("Querying of remote model was not successfull.");
            }
            return this.readFromJson(response.body());
        }
        catch (IOException | InterruptedException e) {
            throw (DependableMLException)DependableMLException.supplierWithMessageAndCause("Something went wrong during communication with remote model.", e).get();
        }
    }

    private URI adjustQueryUri(URI modelURI) {
        String adjustedUri = modelURI.toString().concat(PREDICTION_ROUTE);
        try {
            return new URI(adjustedUri);
        }
        catch (URISyntaxException e) {
            throw (DependableMLException)DependableMLException.supplierWithMessageAndCause(String.format("The syntax of the adjusted uri %s is not valid.", adjustedUri), e).get();
        }
    }

    private String jsonify(InputData inputData) {
        StringBuilder jsonMessage = new StringBuilder();
        for (String each : inputData.getKeys()) {
            Object value = inputData.getValueOf(each);
            jsonMessage.append(this.jsonify(each, value));
        }
        return jsonMessage.deleteCharAt(jsonMessage.length() - 1).toString();
    }

    private String jsonify(String key, Object value) {
        if (value instanceof Number) {
            return String.format("{\"%1s\": %2s},", key, value);
        }
        if (value instanceof File) {
            return String.format("{\"%1s\": \"%2s\"},", key, this.encode((File)value));
        }
        return String.format("{\"%1s\": \"%2s\"},", key, value);
    }

    private String encode(File fileToEncode) {
        String base64Image = "";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream imageInFile = new FileInputStream(fileToEncode);){
                byte[] imageData = new byte[(int)fileToEncode.length()];
                imageInFile.read(imageData);
                base64Image = Base64.getEncoder().encodeToString(imageData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DependableMLException.throwWithMessageAndCause("Something went wrong during file encoding.", e);
        }
        return base64Image;
    }

    private List<OutputData> readFromJson(String json) {
        return this.jsonParser.apply(json);
    }
}

