/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.tests;

import com.google.common.collect.Lists;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.junit.jupiter.api.Assertions;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.core.jobs.LoadModelIntoBlackboardJob;
import org.palladiosimulator.analyzer.workflow.jobs.EventsTransformationJob;
import org.palladiosimulator.analyzer.workflow.jobs.ValidatePCMModelsJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPrediction;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPredictionConfig;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.PCMInstanceBuilderJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionContext;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionExecutionJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionRunJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.UncertaintyBasedReliabilityPredictionJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResult;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.tests.BaseReliabilityPredictionTest;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.tests.util.PCMTestInstanceBuilderJob;
import org.palladiosimulator.experimentautomation.application.jobs.PrepareBlackboardJob;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.reliability.solver.pcm2markov.Pcm2MarkovStrategy;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.apache.util.ProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.DefaultParameterParser;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionRepository;
import tools.mdsd.probdist.model.basic.loader.BasicDistributionTypesLoader;

public class ReliabilityPredictionTestDefinition {
    private static final String TEST_STRATEGY = "Brute force exploration strategy";
    private PCMSolverWorkflowRunConfiguration pcmRelConfig = null;
    private MarkovTransformationResult pcmRelResult = null;
    private ReliabilityPredictionResult uncertaintyBasedResult = null;
    private List<PredictionResultBasedAssertion> assertions = Lists.newArrayList();
    private Optional<ISeedProvider> seedProvider = Optional.empty();

    private ReliabilityPredictionTestDefinition() {
    }

    public static ReliabilityPredictionTestDefinition createTest() {
        return new ReliabilityPredictionTestDefinition();
    }

    public ReliabilityPredictionTestDefinition givenDefaultRunConfigs() {
        this.pcmRelConfig = this.createDefaultPCMRelConfig();
        return this;
    }

    public ReliabilityPredictionTestDefinition givenCustomRunConfigs(PCMSolverWorkflowRunConfiguration pcmRelConfig) {
        this.pcmRelConfig = pcmRelConfig;
        return this;
    }

    public ReliabilityPredictionTestDefinition whenApplyingPCMRel() {
        Objects.requireNonNull(this.pcmRelConfig, "The PCM-Rel config must be specified first.");
        PCMInstance pcmModel = this.loadPCMInstance();
        Pcm2MarkovStrategy solver = new Pcm2MarkovStrategy(this.pcmRelConfig);
        solver.transform(pcmModel);
        this.pcmRelResult = (MarkovTransformationResult)solver.getAllSolvedValues().get(0);
        return this;
    }

    public ReliabilityPredictionTestDefinition whenApplyingUncertaintyBasedPCMRel() {
        ProbabilityDistributionFactory defaultProbabilityDistributionFactory;
        UncertaintyBasedReliabilityPredictionJob relPredictionJob = new UncertaintyBasedReliabilityPredictionJob();
        relPredictionJob.setBlackboard((Blackboard)new MDSDBlackboard());
        Objects.requireNonNull(this.pcmRelConfig, "The reliability config must be specified.");
        PCMInstanceBuilderJob pcmInstanceBuilderJob = new PCMInstanceBuilderJob(this.pcmRelConfig);
        relPredictionJob.addJob((IJob)pcmInstanceBuilderJob);
        relPredictionJob.addJob((IJob)new LoadModelIntoBlackboardJob(URI.createURI((String)this.getUncertaintyModelURI()), "org.palladiosimulator.pcmmodels.partition"));
        relPredictionJob.addJob((IJob)new PrepareBlackboardJob());
        relPredictionJob.addJob((IJob)new ValidatePCMModelsJob((AbstractPCMWorkflowRunConfiguration)this.pcmRelConfig));
        relPredictionJob.addJob((IJob)new EventsTransformationJob(this.pcmRelConfig.getStoragePluginID(), this.pcmRelConfig.getEventMiddlewareFile(), false));
        ReliabilityPredictionContext context = new ReliabilityPredictionContext(this.pcmRelConfig, this.getUncertaintyModelURI(), TEST_STRATEGY);
        DefaultParameterParser parameterParser = new DefaultParameterParser();
        ProbabilityDistributionFactory probabilityDistributionRegistry = defaultProbabilityDistributionFactory = new ProbabilityDistributionFactory(Optional.empty());
        ProbabilityDistributionFactory probabilityDistributionFactory = defaultProbabilityDistributionFactory;
        ProbabilityDistributionRepository probabilityDistributionRepository = BasicDistributionTypesLoader.loadRepository();
        ProbabilityDistributionRepositoryLookup probDistRepoLookup = new ProbabilityDistributionRepositoryLookup(probabilityDistributionRepository);
        relPredictionJob.add((IJob)new ReliabilityPredictionExecutionJob(context, (IProbabilityDistributionRegistry)probabilityDistributionRegistry, (IProbabilityDistributionFactory)probabilityDistributionFactory, (ParameterParser)parameterParser, (IProbabilityDistributionRepositoryLookup)probDistRepoLookup, this.seedProvider));
        ReliabilityPredictionResultJob resultJob = new ReliabilityPredictionResultJob(context);
        relPredictionJob.add((IJob)resultJob);
        try {
            relPredictionJob.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Assertions.fail((String)"Something went wrong during the uncertainty based reliability job", (Throwable)e);
        }
        this.uncertaintyBasedResult = resultJob.getPredictionResult();
        return this;
    }

    public ReliabilityPredictionTestDefinition whenApplyingUncertaintyBasedPCMRelWith(UncertaintyBasedReliabilityPredictionConfig config, IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup) {
        Objects.requireNonNull(config, "The config must not be null.");
        this.uncertaintyBasedResult = UncertaintyBasedReliabilityPrediction.predict((UncertaintyBasedReliabilityPredictionConfig)config, probabilityDistributionRegistry, probabilityDistributionFactory, (ParameterParser)parameterParser, (IProbabilityDistributionRepositoryLookup)probDistRepoLookup, this.seedProvider);
        return this;
    }

    public ReliabilityPredictionTestDefinition thenAssert(PredictionResultBasedAssertion assertion) {
        this.assertions.add(assertion);
        return this;
    }

    public ReliabilityPredictionTestDefinition thenAssert(PredictionResultBasedAssertion ... assertions) {
        this.assertions.addAll(Lists.newArrayList((Object[])assertions));
        return this;
    }

    public void test() {
        this.assertions.forEach(assertion -> assertion.accept(this.pcmRelResult, this.uncertaintyBasedResult));
    }

    private PCMSolverWorkflowRunConfiguration createDefaultPCMRelConfig() {
        PCMSolverWorkflowRunConfiguration config = new PCMSolverWorkflowRunConfiguration();
        config.setReliabilityAnalysis(true);
        config.setPrintMarkovStatistics(false);
        config.setPrintMarkovSingleResults(false);
        config.setSensitivityModelEnabled(false);
        config.setSensitivityModelFileName(null);
        config.setSensitivityLogFileName(null);
        config.setDeleteTemporaryDataAfterAnalysis(true);
        config.setDistance(1.0);
        config.setDomainSize(32);
        config.setIterationOverPhysicalSystemStatesEnabled(true);
        config.setMarkovModelReductionEnabled(true);
        config.setNumberOfEvaluatedSystemStates(1L);
        config.setNumberOfEvaluatedSystemStatesEnabled(false);
        config.setSolvingTimeLimitEnabled(false);
        config.setLogFile(null);
        config.setNumberOfEvaluatedSystemStatesEnabled(false);
        config.setNumberOfEvaluatedSystemStates(0L);
        config.setNumberOfExactDecimalPlacesEnabled(false);
        config.setNumberOfExactDecimalPlaces(0);
        config.setSolvingTimeLimitEnabled(false);
        config.setMarkovModelStorageEnabled(false);
        config.setIterationOverPhysicalSystemStatesEnabled(true);
        config.setMarkovEvaluationMode("POINTSOFFAILURE");
        config.setSaveResultsToFileEnabled(false);
        config.setRMIMiddlewareFile("pathmap://PCM_MODELS/Glassfish.repository");
        config.setEventMiddlewareFile("pathmap://PCM_MODELS/default_event_middleware.repository");
        config.setUsageModelFile(BaseReliabilityPredictionTest.makeAbsolute(BaseReliabilityPredictionTest.RELATIVE_USAGEMODEL_TEST_MODEL_PATH));
        config.setAllocationFiles((List)Lists.newArrayList((Object[])new String[]{BaseReliabilityPredictionTest.makeAbsolute(BaseReliabilityPredictionTest.RELATIVE_ALLOCATION_TEST_MODEL_PATH)}));
        return config;
    }

    private PCMInstance loadPCMInstance() {
        return new PCMInstance((PCMResourceSetPartition)this.loadPcmModel().getPartition("org.palladiosimulator.pcmmodels.partition"));
    }

    private MDSDBlackboard loadPcmModel() {
        PCMTestInstanceBuilderJob pcmBuilderJob = new PCMTestInstanceBuilderJob(this.pcmRelConfig);
        try {
            pcmBuilderJob.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (JobFailedException | UserCanceledException e) {
            throw new RuntimeException("Something went wrong while building the PCM instance.", e);
        }
        return (MDSDBlackboard)pcmBuilderJob.getBlackboard();
    }

    private String getUncertaintyModelURI() {
        return BaseReliabilityPredictionTest.makeAbsolute(BaseReliabilityPredictionTest.RELATIVE_UNCERTAINTY_TEST_MODEL_PATH);
    }

    public static interface PredictionResultBasedAssertion
    extends BiConsumer<MarkovTransformationResult, ReliabilityPredictionResult> {
    }

    private class ReliabilityPredictionResultJob
    extends ReliabilityPredictionRunJob {
        public ReliabilityPredictionResultJob(ReliabilityPredictionContext context) {
            super(context);
        }

        public ReliabilityPredictionResult getPredictionResult() {
            return this.context.result;
        }
    }
}

