/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.tests;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyRepository;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.tests.BaseReliabilityPredictionTest;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.tests.ReliabilityPredictionTestDefinition;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.parser.DefaultParameterParser;
import tools.mdsd.probdist.api.parser.ParameterParser;

class UncertaintyBasedReliabilityPredictionTest
extends BaseReliabilityPredictionTest {
    private static final String ML_VARIABLE = "MLPredictionSensitivity";

    UncertaintyBasedReliabilityPredictionTest() {
    }

    @Ignore
    public void test() {
        DefaultParameterParser parameterParser = new DefaultParameterParser();
        this.getUncertaintyStateSpace((ParameterParser)parameterParser).forEach(this::test);
    }

    public void test(DiscreteUncertaintyStateSpace.UncertaintyState uncertaintyState) {
        ReliabilityPredictionTestDefinition.createTest().givenDefaultRunConfigs().whenApplyingPCMRel().whenApplyingUncertaintyBasedPCMRel().thenAssert(this.uncertaintyProbabilityIsSmallerThanSuccessProbability(uncertaintyState)).test();
    }

    private ReliabilityPredictionTestDefinition.PredictionResultBasedAssertion uncertaintyProbabilityIsSmallerThanSuccessProbability(DiscreteUncertaintyStateSpace.UncertaintyState uncertaintyState) {
        return (pcmRelResult, uncertaintyResult) -> {
            double success = pcmRelResult.getSuccessProbability();
            UsageScenario usageScenario = pcmRelResult.getScenario();
            ReliabilityPredictionResultPerScenario predictionPerUsage = (ReliabilityPredictionResultPerScenario)uncertaintyResult.filterPredictionResultsFor(usageScenario).iterator().next();
            double joined = predictionPerUsage.getJoinedSuccessAndUncertaintyProbability();
            Assert.assertTrue((joined <= success ? 1 : 0) != 0);
        };
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> getUncertaintyStateSpace(ParameterParser parameterParser) {
        Set stateSpace = DiscreteUncertaintyStateSpace.valueSpaceOf((UncertaintyInducedFailureType)this.getUncertaintyInducedFailureType(), (ParameterParser)parameterParser);
        this.excludeMLUncertaintyState(stateSpace);
        return this.enrichToValuedUncertaintyStates(stateSpace);
    }

    private void excludeMLUncertaintyState(Set<DiscreteUncertaintyStateSpace.UncertaintyState> stateSpace) {
        stateSpace.removeIf(each -> each.getId().equals(ML_VARIABLE));
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> enrichToValuedUncertaintyStates(Set<DiscreteUncertaintyStateSpace.UncertaintyState> stateSpace) {
        DiscreteUncertaintyStateSpace.UncertaintyState stateToEnrich = stateSpace.iterator().next();
        HashSet enriched = Sets.newHashSet();
        for (CategoricalValue each : stateToEnrich.getValueSpace()) {
            enriched.add(stateToEnrich.newValuedStateWith(each));
        }
        return enriched;
    }

    private UncertaintyInducedFailureType getUncertaintyInducedFailureType() {
        URI repoURI = URI.createURI((String)UncertaintyBasedReliabilityPredictionTest.makeAbsolute(RELATIVE_UNCERTAINTY_TEST_MODEL_PATH), (boolean)true);
        Resource repoResource = new ResourceSetImpl().getResource(repoURI, true);
        UncertaintyRepository repo = Optional.ofNullable(repoResource).map(Resource::getContents).map(Collection::iterator).map(Iterator::next).filter(UncertaintyRepository.class::isInstance).map(UncertaintyRepository.class::cast).orElseThrow();
        return (UncertaintyInducedFailureType)repo.getUncertaintyInducedFailureTypes().get(0);
    }
}

