/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.markov;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class ReliabilityPredictionResult {
    private static final double ZERO_PROBABILITY = 0.0;
    private final Set<ReliabilityPredictionResultPerScenario> results;

    public ReliabilityPredictionResult() {
        this.results = Sets.newHashSet();
    }

    public ReliabilityPredictionResult(Set<ReliabilityPredictionResultPerScenario> results) {
        this.results = results;
    }

    protected void add(ReliabilityPredictionResultPerScenario result) {
        this.results.add(result);
    }

    protected void addAll(Set<ReliabilityPredictionResultPerScenario> results) {
        this.results.addAll(results);
    }

    public Set<ReliabilityPredictionResultPerScenario> filterPredictionResultsFor(UsageScenario scenario) {
        return this.results.stream().filter(each -> each.getUsageScenario().getId().equals(scenario.getId())).collect(Collectors.toSet());
    }

    public double getProbabilityOfSuccess(UsageScenario scenario) {
        return this.marginalizingUncertainties(scenario);
    }

    public double getProbabilityOfFailure(UsageScenario scenario) {
        return 1.0 - this.getProbabilityOfSuccess(scenario);
    }

    private double marginalizingUncertainties(UsageScenario scenario) {
        Set<ReliabilityPredictionResultPerScenario> scenarioSpecificResults = this.filterPredictionResultsFor(scenario);
        Double summedUncertaintyProbs = scenarioSpecificResults.stream().map(ReliabilityPredictionResultPerScenario::getProbabilityOfUncertainty).reduce(Double::sum).orElse(0.0);
        this.requireUnitMeasure(summedUncertaintyProbs);
        Double probabilityOfSuccess = scenarioSpecificResults.stream().map(ReliabilityPredictionResultPerScenario::getJoinedSuccessAndUncertaintyProbability).reduce(Double::sum).orElseThrow(() -> new RuntimeException("Something went wrong during marginalizing process."));
        return probabilityOfSuccess;
    }

    private void requireUnitMeasure(double summedUncertaintyProbs) {
        double tolerance = 1.0E-4;
        if (Math.abs(1.0 - summedUncertaintyProbs) > 1.0E-4) {
            throw new RuntimeException("The sum of uncertainty probabilities must be equal to one.");
        }
    }
}

