/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModel;
import org.palladiosimulator.envdyn.api.entity.bn.BayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributionfunction.TabularCPD;
import tools.mdsd.probdist.distributionfunction.TabularCPDEntry;

public class BayesianUncertaintyModel
implements UncertaintyModel {
    private final BayesianNetwork<CategoricalValue> bayesianNetwork;
    private final GroundRandomVariable failureVariable;
    private final Set<DiscreteUncertaintyStateSpace.UncertaintyState> valueSpace;
    private final ParameterParser parameterParser;

    public BayesianUncertaintyModel(UncertaintyInducedFailureType uncertainty, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser) {
        this.bayesianNetwork = new BayesianNetwork(null, uncertainty.getUncertaintyModel(), probabilityDistributionFactory);
        this.failureVariable = uncertainty.getFailureVariable();
        this.valueSpace = this.computeValueSpace(uncertainty);
        this.parameterParser = parameterParser;
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> computeValueSpace(UncertaintyInducedFailureType uncertainty) {
        Set<DiscreteUncertaintyStateSpace.UncertaintyState> statesIncludingFailureVar = DiscreteUncertaintyStateSpace.valueSpaceOf(uncertainty, this.parameterParser);
        return this.excludeFailureVariable(statesIncludingFailureVar);
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> excludeFailureVariable(Set<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        values.removeIf(state -> state.getId().equals(this.failureVariable.getEntityName()));
        return values;
    }

    @Override
    public Set<DiscreteUncertaintyStateSpace.UncertaintyState> getValueSpace() {
        return this.valueSpace;
    }

    @Override
    public double probability(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        return this.marginalizingFailureVariable(this.filterRelevantValues(values), this.parameterParser);
    }

    @Override
    public double probabilityOfFailureGiven(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        Double probOfFailure = this.bayesianNetwork.probability(this.filterRelevantValues(values));
        double probOfUncertainty = this.probability(values);
        return probOfFailure / probOfUncertainty;
    }

    private double marginalizingFailureVariable(List<InputValue<CategoricalValue>> values, ParameterParser parameterParser) {
        double probability = 0.0;
        for (CategoricalValue each : this.retrieveValueSpaceOf(this.failureVariable, parameterParser)) {
            ArrayList copiedValues = Lists.newArrayList(values);
            copiedValues.add(InputValue.create((Value)each, (GroundRandomVariable)this.failureVariable));
            probability += this.bayesianNetwork.probability((List)copiedValues).doubleValue();
        }
        return probability;
    }

    private Set<CategoricalValue> retrieveValueSpaceOf(GroundRandomVariable variable, ParameterParser parameterParser) {
        ProbabilityDistribution distribution = this.failureVariable.getDescriptiveModel().getDistribution();
        ParamRepresentation paramRep = ((Parameter)distribution.getParams().get(0)).getRepresentation();
        if (paramRep instanceof TabularCPD) {
            SimpleParameter param = ((TabularCPDEntry)((TabularCPD)TabularCPD.class.cast(paramRep)).getCpdEntries().get(0)).getEntry();
            Set samples = parameterParser.parseSampleSpace(param);
            return samples.stream().map(each -> each.value).collect(Collectors.toSet());
        }
        throw new RuntimeException(String.format("Variable %s is supposed to be described by a conditional probability distribution.", variable.getEntityName()));
    }

    private List<InputValue<CategoricalValue>> filterRelevantValues(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        ArrayList inputValues = Lists.newArrayList();
        for (GroundRandomVariable each : this.bayesianNetwork.getGroundVariables()) {
            CategoricalValue value = this.findValue(each, values).orElseThrow();
            inputValues.add(InputValue.create((Value)value, (GroundRandomVariable)each));
        }
        return inputValues;
    }

    private Optional<CategoricalValue> findValue(GroundRandomVariable variable, List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        return values.stream().filter(each -> each.getId().equals(variable.getEntityName())).map(DiscreteUncertaintyStateSpace.UncertaintyState::getValue).findFirst();
    }
}

