/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.model;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.ProbabilisticSensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.api.MLSensitivityAnalyser;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.CustomizedSensitivityProperty;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.SensitivityProperty;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.property.conversion.SensitivityPropertyConventions;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class MLInducedUncertaintyModel
implements UncertaintyModel {
    private final Set<DiscreteUncertaintyStateSpace.UncertaintyState> valueSpace;
    private final ProbabilisticSensitivityModel sensitivityModel;

    public MLInducedUncertaintyModel(UncertaintyInducedFailureType uncertainty, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        this.sensitivityModel = this.initSensitivityModel(uncertainty, probabilityDistributionFactory, seedProvider);
        this.valueSpace = this.computeValueSpace(uncertainty, parameterParser);
    }

    private ProbabilisticSensitivityModel initSensitivityModel(UncertaintyInducedFailureType uncertainty, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, Optional<ISeedProvider> seedProvider) {
        ProbabilisticSensitivityModel model = ProbabilisticSensitivityModel.createFrom((GroundProbabilisticNetwork)this.getProbabilisticModel(uncertainty), (TemplateVariableDefinitions)this.getTemplates(uncertainty), probabilityDistributionFactory, seedProvider);
        model.setMLOutcomeMeasure(SensitivityModel.MLOutcomeMeasure.FAIL);
        return model;
    }

    private GroundProbabilisticNetwork getProbabilisticModel(UncertaintyInducedFailureType uncertainty) {
        return uncertainty.getUncertaintyModel();
    }

    private TemplateVariableDefinitions getTemplates(UncertaintyInducedFailureType uncertainty) {
        LocalProbabilisticNetwork localModel = (LocalProbabilisticNetwork)uncertainty.getUncertaintyModel().getLocalProbabilisticModels().get(0);
        GroundRandomVariable anyVariable = (GroundRandomVariable)localModel.getGroundRandomVariables().get(0);
        return (TemplateVariableDefinitions)anyVariable.getInstantiatedTemplate().eContainer();
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> computeValueSpace(UncertaintyInducedFailureType uncertainty, ParameterParser parameterParser) {
        Set<DiscreteUncertaintyStateSpace.UncertaintyState> statesIncludingMLVar = DiscreteUncertaintyStateSpace.valueSpaceOf(uncertainty, parameterParser);
        return this.excludeMLInputVariable(statesIncludingMLVar);
    }

    private Set<DiscreteUncertaintyStateSpace.UncertaintyState> excludeMLInputVariable(Set<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        GroundRandomVariable mlVariable = this.sensitivityModel.findMLRandomVariable();
        values.removeIf(state -> state.getId().equals(mlVariable.getEntityName()));
        return values;
    }

    @Override
    public Set<DiscreteUncertaintyStateSpace.UncertaintyState> getValueSpace() {
        return this.valueSpace;
    }

    @Override
    public double probability(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        return this.marginalizingMLVariable(this.filterRelevantStates(values));
    }

    private double marginalizingMLVariable(List<SensitivityProperty> properties) {
        double probability = 0.0;
        this.sensitivityModel.setMLOutcomeMeasure(SensitivityModel.MLOutcomeMeasure.SUCCESS);
        probability += this.sensitivityModel.inferSensitivity(properties);
        this.sensitivityModel.setMLOutcomeMeasure(SensitivityModel.MLOutcomeMeasure.FAIL);
        return probability += this.sensitivityModel.inferSensitivity(properties);
    }

    @Override
    public double probabilityOfFailureGiven(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        return this.sensitivityModel.conditionalSensitivity(this.filterRelevantStates(values));
    }

    private List<SensitivityProperty> filterRelevantStates(List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        return values.stream().map(this::toMeasurableProperty).collect(Collectors.toList());
    }

    private SensitivityProperty toMeasurableProperty(DiscreteUncertaintyStateSpace.UncertaintyState state) {
        return this.findMeasurablePropertyOf(state).orElse((SensitivityProperty)this.createCustomizedMeasurableProperty(state));
    }

    private Optional<SensitivityProperty> findMeasurablePropertyOf(DiscreteUncertaintyStateSpace.UncertaintyState state) {
        for (PropertyMeasure each : MLSensitivityAnalyser.getAnalysablePropertyMeasures()) {
            if (!this.areSemanticallyEqual(state, each)) continue;
            PropertyMeasure.MeasurableSensitivityProperty result = (PropertyMeasure.MeasurableSensitivityProperty)each.findMeasurablePropertyWith(state.getValue()).get();
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private boolean areSemanticallyEqual(DiscreteUncertaintyStateSpace.UncertaintyState state, PropertyMeasure measure) {
        return SensitivityPropertyConventions.areSemanticallyEqual((TemplateVariable)state.getInstantiatedTemplate(), (PropertyMeasure)measure);
    }

    private CustomizedSensitivityProperty createCustomizedMeasurableProperty(DiscreteUncertaintyStateSpace.UncertaintyState state) {
        return CustomizedSensitivityProperty.createFrom((CategoricalValue)state.getValue(), (TemplateVariable)state.getInstantiatedTemplate());
    }
}

