/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;

public class PredictionResultFormatting {
    public static String asString(List<DiscreteUncertaintyStateSpace.UncertaintyState> uncertainties) {
        return String.join((CharSequence)",", uncertainties.stream().map(each -> (String)each.getValue().get()).collect(Collectors.toList()));
    }

    public static Iterator<ReliabilityPredictionResultPerScenario> sortByUncertainties(Set<ReliabilityPredictionResultPerScenario> unsorted) {
        TreeSet<ReliabilityPredictionResultPerScenario> sorted = new TreeSet<ReliabilityPredictionResultPerScenario>(new Comparator<ReliabilityPredictionResultPerScenario>(){

            @Override
            public int compare(ReliabilityPredictionResultPerScenario r1, ReliabilityPredictionResultPerScenario r2) {
                String strUncertainties1 = PredictionResultFormatting.asString(r1.getUncertainties());
                String strUncertainties2 = PredictionResultFormatting.asString(r2.getUncertainties());
                ArrayList uncertainties = Lists.newArrayList((Object[])new String[]{strUncertainties1, strUncertainties2});
                Collections.sort(uncertainties);
                return ((String)uncertainties.get(0)).equals(strUncertainties1) ? -1 : 1;
            }
        });
        sorted.addAll(unsorted);
        return sorted.iterator();
    }
}

