/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalCountermeasure;
import org.palladiosimulator.dependability.reliability.uncertainty.DeterministicImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.GlobalUncertaintyCountermeasure;
import org.palladiosimulator.dependability.reliability.uncertainty.ProbabilisticImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyRepository;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintySpecificCountermeasure;
import org.palladiosimulator.dependability.reliability.uncertainty.improvement.UncertaintyImprovementCalculator;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModelManager;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.ArchitecturalPreconditionUtil;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.UncertaintyModelUtil;
import org.palladiosimulator.dependability.reliability.uncertainty.util.UncertaintySwitch;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.solver.core.models.PCMInstance;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ConditionalProbabilityDistribution;
import tools.mdsd.probdist.api.entity.UnivariateProbabilitiyMassFunction;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributionfunction.Domain;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;

public class ArchitecturalCountermeasureOperator {
    private final PCMInstance pcmModel;
    private final UncertaintyRepository uncertaintyRepo;
    private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
    private final ParameterParser parameterParser;
    private final Optional<ISeedProvider> seedProvider;

    private ArchitecturalCountermeasureOperator(PCMInstance pcmModel, UncertaintyRepository uncertaintyRepo, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        this.pcmModel = pcmModel;
        this.uncertaintyRepo = uncertaintyRepo;
        this.probabilityDistributionFactory = probabilityDistributionFactory;
        this.parameterParser = parameterParser;
        this.seedProvider = seedProvider;
    }

    public static ArchitecturalCountermeasureOperator createOperatorFor(PCMInstance pcmModel, UncertaintyRepository uncertaintyRepo, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        return new ArchitecturalCountermeasureOperator(pcmModel, uncertaintyRepo, probabilityDistributionFactory, parameterParser, seedProvider);
    }

    public List<DiscreteUncertaintyStateSpace.UncertaintyState> applyToUncertainties(List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple) {
        if (this.uncertaintyRepo.getArchitecturalCountermeasures().size() == 0) {
            return stateTuple;
        }
        this.filterApplicableCountermeasures().forEach(c -> this.applyUncertaintySpecific((ArchitecturalCountermeasure)c, stateTuple));
        return stateTuple;
    }

    public void applyToUncertaintyModels() {
        if (this.uncertaintyRepo.getArchitecturalCountermeasures().size() == 0) {
            return;
        }
        this.filterApplicableCountermeasures().forEach(this::apply);
    }

    private List<ArchitecturalCountermeasure> filterApplicableCountermeasures() {
        return this.uncertaintyRepo.getArchitecturalCountermeasures().stream().filter(c -> ArchitecturalPreconditionUtil.allPreconditionsFulfilled(c, this.pcmModel)).filter(c -> ArchitecturalPreconditionUtil.allPreconditionsFulfilled(c.getAppliedFailureType(), this.pcmModel)).collect(Collectors.toList());
    }

    private void applyUncertaintySpecific(ArchitecturalCountermeasure countermeasure, final List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple) {
        new UncertaintySwitch<Void>(){

            public Void caseUncertaintySpecificCountermeasure(UncertaintySpecificCountermeasure countermeasure) {
                ConditionalProbabilityDistribution improvement = ArchitecturalCountermeasureOperator.this.createCPDFrom(countermeasure.getUncertaintyImprovement());
                DiscreteUncertaintyStateSpace.UncertaintyState targetUncertainty = stateTuple.stream().filter(each -> each.instantiates(countermeasure.getTargetUncertainty())).findAny().orElseThrow(() -> new RuntimeException("There is no uncertainty with target for " + countermeasure.getEntityName()));
                List<Conditionable.Conditional<CategoricalValue>> valueToImprove = ArchitecturalCountermeasureOperator.this.asConditional(targetUncertainty.getValue());
                CategoricalValue improvedValue = improvement.given(valueToImprove).sample();
                stateTuple.remove(targetUncertainty);
                DiscreteUncertaintyStateSpace.UncertaintyState improvedUncertainty = targetUncertainty.newValuedStateWith(improvedValue);
                stateTuple.add(improvedUncertainty);
                return null;
            }

            public Void caseGlobalUncertaintyCountermeasure(GlobalUncertaintyCountermeasure countermeasure) {
                ArchitecturalCountermeasureOperator.this.apply((ArchitecturalCountermeasure)countermeasure);
                return null;
            }
        }.doSwitch((EObject)countermeasure);
    }

    private void apply(ArchitecturalCountermeasure countermeasure) {
        new UncertaintySwitch<Void>(){

            public Void caseUncertaintySpecificCountermeasure(UncertaintySpecificCountermeasure countermeasure) {
                UncertaintyInducedFailureType surrogate = ArchitecturalCountermeasureOperator.this.makeSurrogate(countermeasure.getAppliedFailureType());
                GroundProbabilisticNetwork uncertaintyModel = surrogate.getUncertaintyModel();
                GroundRandomVariable affectedVariable = ((LocalProbabilisticNetwork)uncertaintyModel.getLocalProbabilisticModels().get(0)).getGroundRandomVariables().stream().filter(variable -> variable.getInstantiatedTemplate().getId().equals(countermeasure.getTargetUncertainty().getId())).findFirst().get();
                ArchitecturalCountermeasureOperator.this.switchDistributions(affectedVariable, countermeasure.getUncertaintyImprovement(), ArchitecturalCountermeasureOperator.this.parameterParser);
                UncertaintyModelManager.get().updateModel(surrogate, ArchitecturalCountermeasureOperator.this.probabilityDistributionFactory, ArchitecturalCountermeasureOperator.this.parameterParser, ArchitecturalCountermeasureOperator.this.seedProvider);
                return null;
            }

            public Void caseGlobalUncertaintyCountermeasure(GlobalUncertaintyCountermeasure countermeasure) {
                for (UncertaintyInducedFailureType each : ArchitecturalCountermeasureOperator.this.uncertaintyRepo.getUncertaintyInducedFailureTypes()) {
                    if (!each.getId().equals(countermeasure.getAppliedFailureType().getId())) continue;
                    UncertaintyInducedFailureType surrogate = ArchitecturalCountermeasureOperator.this.makeSurrogate(countermeasure.getAppliedFailureType());
                    GroundRandomVariable original = ArchitecturalCountermeasureOperator.this.retrieveFailureVariableFrom(surrogate);
                    GroundRandomVariable improved = ArchitecturalCountermeasureOperator.this.retrieveFailureVariableFrom(countermeasure.getImprovedUncertaintyModel());
                    original.getDescriptiveModel().setDistribution(improved.getDescriptiveModel().getDistribution());
                    UncertaintyModelManager.get().updateModel(surrogate, ArchitecturalCountermeasureOperator.this.probabilityDistributionFactory, ArchitecturalCountermeasureOperator.this.parameterParser, ArchitecturalCountermeasureOperator.this.seedProvider);
                }
                return null;
            }
        }.doSwitch((EObject)countermeasure);
    }

    private void switchDistributions(GroundRandomVariable affectedVariable, UncertaintyImprovement improvement, ParameterParser parameterParser) {
        UnivariateProbabilitiyMassFunction generator = this.createGeneratorDistribution(affectedVariable, improvement, parameterParser);
        ProbabilityDistribution oldDistribution = affectedVariable.getDescriptiveModel().getDistribution();
        EList params = oldDistribution.getParams();
        if (params.size() != 1 || !SimpleParameter.class.isInstance(((Parameter)params.get(0)).getRepresentation())) {
            throw new IllegalArgumentException("The distribution structure is not supported.");
        }
        SimpleParameter adjustedParam = this.generateDistributionParams((SimpleParameter)((Parameter)params.get(0)).getRepresentation(), generator, parameterParser);
        ((Parameter)params.get(0)).setRepresentation((ParamRepresentation)adjustedParam);
    }

    private SimpleParameter generateDistributionParams(SimpleParameter param, UnivariateProbabilitiyMassFunction generator, ParameterParser parameterParser) {
        Set samples = parameterParser.parseSampleSpace(param);
        for (ParameterParser.Sample each : samples) {
            Double newProbability;
            each.probability = newProbability = generator.probability((Object)each.value);
        }
        StringBuilder builder = new StringBuilder();
        for (ParameterParser.Sample each : samples) {
            builder.append(String.format("{%1s,%2s};", each.value, each.probability));
        }
        String strParam = builder.deleteCharAt(builder.length() - 1).toString();
        param.setValue(strParam);
        return param;
    }

    private UnivariateProbabilitiyMassFunction createGeneratorDistribution(final GroundRandomVariable affectedVariable, UncertaintyImprovement uncertaintyImprovement, final ParameterParser parameterParser) {
        ProbabilityDistribution oldDistribution = affectedVariable.getDescriptiveModel().getDistribution();
        return new UnivariateProbabilitiyMassFunction(oldDistribution.getInstantiated(), oldDistribution, uncertaintyImprovement){
            private final UnivariateProbabilitiyMassFunction oldDistFunction;
            private final ConditionalProbabilityDistribution improvement;
            {
                super($anonymous0);
                this.oldDistFunction = (UnivariateProbabilitiyMassFunction)ArchitecturalCountermeasureOperator.this.probabilityDistributionFactory.getInstanceOf(probabilityDistribution).orElseThrow();
                this.improvement = ArchitecturalCountermeasureOperator.this.createCPDFrom(uncertaintyImprovement);
            }

            public void init(Optional<ISeedProvider> seedProvider) {
                if (this.initialized) {
                    throw new RuntimeException("initialized");
                }
                this.initialized = true;
                this.oldDistFunction.init(seedProvider);
                this.improvement.init(seedProvider);
            }

            public CategoricalValue sample() {
                if (!this.initialized) {
                    throw new RuntimeException("not initialized");
                }
                List<Conditionable.Conditional<CategoricalValue>> conditional = ArchitecturalCountermeasureOperator.this.asConditional((CategoricalValue)this.oldDistFunction.sample());
                return this.improvement.given(conditional).sample();
            }

            public Double probability(CategoricalValue value) {
                double probability = 0.0;
                for (CategoricalValue each : DiscreteUncertaintyStateSpace.toUncertaintyState(affectedVariable, parameterParser).getValueSpace()) {
                    Double probOfUncertainty = this.oldDistFunction.probability((Object)each);
                    Double condProb = this.improvement.given(ArchitecturalCountermeasureOperator.this.asConditional(each)).probability(value);
                    probability += probOfUncertainty * condProb;
                }
                return probability;
            }
        };
    }

    private ConditionalProbabilityDistribution createCPDFrom(UncertaintyImprovement improvement) {
        return (ConditionalProbabilityDistribution)new UncertaintySwitch<ConditionalProbabilityDistribution>(){

            public ConditionalProbabilityDistribution caseProbabilisticImprovement(ProbabilisticImprovement probImprovement) {
                return UncertaintyImprovementCalculator.get().createCPD(probImprovement.getProbabilityDistribution(), ArchitecturalCountermeasureOperator.this.probabilityDistributionFactory);
            }

            public ConditionalProbabilityDistribution caseDeterministicImprovement(DeterministicImprovement detImprovement) {
                return UncertaintyImprovementCalculator.get().createIndicatorCPD(detImprovement, ArchitecturalCountermeasureOperator.this.probabilityDistributionFactory);
            }
        }.doSwitch((EObject)improvement);
    }

    private List<Conditionable.Conditional<CategoricalValue>> asConditional(CategoricalValue value) {
        return Lists.newArrayList((Object[])new Conditionable.Conditional[]{new Conditionable.Conditional(Domain.CATEGORY, (Value)value)});
    }

    private GroundRandomVariable retrieveFailureVariableFrom(UncertaintyInducedFailureType type) {
        if (type.getFailureVariable() != null) {
            return type.getFailureVariable();
        }
        return this.retrieveFailureVariableFrom(type.getUncertaintyModel());
    }

    private GroundRandomVariable retrieveFailureVariableFrom(GroundProbabilisticNetwork model) {
        Set<GroundRandomVariable> results = UncertaintyModelUtil.filterRandomVariablesOnlyWithParent(model);
        if (results.size() != 1) {
            throw new RuntimeException("There are several variables with parents.");
        }
        return results.iterator().next();
    }

    private UncertaintyInducedFailureType makeSurrogate(UncertaintyInducedFailureType failureType) {
        UncertaintyInducedFailureType surrogate = (UncertaintyInducedFailureType)EcoreUtil.copy((EObject)failureType);
        surrogate.setFailureVariable(failureType.getFailureVariable());
        surrogate.setRefines(failureType.getRefines());
        surrogate.getArchitecturalPreconditions().addAll((Collection)failureType.getArchitecturalPreconditions());
        GroundProbabilisticNetwork originalModel = failureType.getUncertaintyModel();
        GroundProbabilisticNetwork surrogatedModel = (GroundProbabilisticNetwork)EcoreUtil.copy((EObject)originalModel);
        for (GroundProbabilisticModel each : originalModel.getLocalModels()) {
            GroundProbabilisticModel surrogatedGroundModel = (GroundProbabilisticModel)EcoreUtil.copy((EObject)each);
            surrogatedGroundModel.setDistribution(each.getDistribution());
            surrogatedGroundModel.setInstantiatedFactor(each.getInstantiatedFactor());
            surrogatedModel.getLocalModels().add((Object)surrogatedGroundModel);
        }
        for (LocalProbabilisticNetwork eachNet : originalModel.getLocalProbabilisticModels()) {
            LocalProbabilisticNetwork surrogatedLocalNetwork = (LocalProbabilisticNetwork)EcoreUtil.copy((EObject)eachNet);
            for (GroundRandomVariable eachVar : eachNet.getGroundRandomVariables()) {
                GroundRandomVariable surrogatedVariable = surrogatedLocalNetwork.getGroundRandomVariables().stream().filter(v -> v.getId().equals(eachVar.getId())).findFirst().orElseThrow(() -> new RuntimeException("Ground random variables have not been properly copied."));
                surrogatedVariable.setInstantiatedTemplate(eachVar.getInstantiatedTemplate());
                if (!eachVar.getAppliedObjects().isEmpty()) {
                    surrogatedVariable.getAppliedObjects().addAll((Collection)eachVar.getAppliedObjects());
                }
                if (!eachVar.getDependenceStructure().isEmpty()) {
                    surrogatedVariable.getDependenceStructure().addAll((Collection)eachVar.getDependenceStructure());
                }
                GroundProbabilisticModel descModel = surrogatedModel.getLocalModels().stream().filter(m -> m.getId().equals(eachVar.getDescriptiveModel().getId())).findFirst().orElseThrow(() -> new RuntimeException("Could not found local model: " + eachVar.getDescriptiveModel().getEntityName()));
                surrogatedVariable.setDescriptiveModel(descModel);
                surrogatedLocalNetwork.getGroundRandomVariables().add((Object)surrogatedVariable);
            }
            surrogatedModel.getLocalProbabilisticModels().add((Object)surrogatedLocalNetwork);
        }
        surrogate.setUncertaintyModel(surrogatedModel);
        return surrogate;
    }
}

