/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.api;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyPackage;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyRepository;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPrediction;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.PCMInstanceBuilderJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.StateSpaceExplorationStrategy;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;

public class UncertaintyBasedReliabilityPredictionConfig {
    private final PCMSolverWorkflowRunConfiguration runConfig;
    private final Optional<StateSpaceExplorationStrategy> explorationStrategy;
    private final UncertaintyRepository uncertaintyRepo;
    private final PCMInstance pcm;

    public UncertaintyBasedReliabilityPredictionConfig(PCMSolverWorkflowRunConfiguration runConfig, StateSpaceExplorationStrategy explorationStrategy, UncertaintyRepository uncertaintyRepo, PCMInstance pcm) {
        this.runConfig = runConfig;
        this.explorationStrategy = Optional.ofNullable(explorationStrategy);
        this.uncertaintyRepo = uncertaintyRepo;
        this.pcm = pcm;
    }

    public static UncertaintyBasedReliabilityPredictionConfigBuilder newBuilder() {
        return new UncertaintyBasedReliabilityPredictionConfigBuilder();
    }

    public PCMSolverWorkflowRunConfiguration getRunConfig() {
        return this.runConfig;
    }

    public Optional<StateSpaceExplorationStrategy> getStateSpaceExplorationStrategy() {
        return this.explorationStrategy;
    }

    public UncertaintyRepository getUncertaintyRepository() {
        return this.uncertaintyRepo;
    }

    public PCMInstance getPCMInstance() {
        return this.pcm;
    }

    public static class UncertaintyBasedReliabilityPredictionConfigBuilder {
        private PCMSolverWorkflowRunConfiguration runConfig;
        private MDSDBlackboard blackboard;
        private String explorationStrategyName;
        private String uncertaintyRepository;

        private UncertaintyBasedReliabilityPredictionConfigBuilder() {
        }

        public UncertaintyBasedReliabilityPredictionConfigBuilder withReliabilityRunConfig(PCMSolverWorkflowRunConfiguration runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionConfigBuilder andPcmModels(MDSDBlackboard blackboard) {
            this.blackboard = blackboard;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionConfigBuilder exploreStateSpaceWith(String strategyName) {
            this.explorationStrategyName = strategyName;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionConfigBuilder andUncertainties(String uncertaintyRepository) {
            this.uncertaintyRepository = uncertaintyRepository;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionConfig build() {
            Objects.requireNonNull(this.runConfig, "The reliability run config must not be null.");
            this.requireValidString(this.explorationStrategyName);
            StateSpaceExplorationStrategy strategy = UncertaintyBasedReliabilityPrediction.findStrategyWith(this.explorationStrategyName).orElse(null);
            UncertaintyRepository uncertaintyRepo = this.loadUncertaintyRepo();
            PCMInstance pcmInstance = new PCMInstance((PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition"));
            return new UncertaintyBasedReliabilityPredictionConfig(this.runConfig, strategy, uncertaintyRepo, pcmInstance);
        }

        public UncertaintyBasedReliabilityPredictionConfig rebuild(UncertaintyBasedReliabilityPredictionConfig config, MDSDBlackboard blackboard) {
            PCMSolverWorkflowRunConfiguration runConfig = config.runConfig;
            StateSpaceExplorationStrategy strategy = config.explorationStrategy.isPresent() ? config.explorationStrategy.get() : null;
            UncertaintyRepository uncertaintyRepo = config.uncertaintyRepo;
            PCMInstance pcmInstance = this.rebuildPCMInstance(blackboard, config.runConfig);
            return new UncertaintyBasedReliabilityPredictionConfig(runConfig, strategy, uncertaintyRepo, pcmInstance);
        }

        private PCMInstance rebuildPCMInstance(MDSDBlackboard blackboard, PCMSolverWorkflowRunConfiguration runConfig) {
            return this.executePCMInstanceBuildJob(new PCMInstanceBuilderJob(runConfig, blackboard));
        }

        private PCMInstance executePCMInstanceBuildJob(PCMInstanceBuilderJob pcmBuilderJob) {
            try {
                pcmBuilderJob.execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JobFailedException | UserCanceledException e) {
                throw new RuntimeException("Something went wrong while building the PCM instance.", e);
            }
            return new PCMInstance((PCMResourceSetPartition)((MDSDBlackboard)pcmBuilderJob.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition"));
        }

        private UncertaintyRepository loadUncertaintyRepo() {
            if (this.uncertaintyRepository == null) {
                PCMResourceSetPartition rs = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
                List repo = rs.getElement(UncertaintyPackage.eINSTANCE.getUncertaintyRepository());
                if (repo.isEmpty()) {
                    throw new RuntimeException("The uncertainty model is neither specified by an URI nor loaded to the blackboard.");
                }
                return (UncertaintyRepository)repo.get(0);
            }
            this.requireValidString(this.uncertaintyRepository);
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            rs.getPackageRegistry().put((Object)"http://palladiosimulator.org/Uncertainty/1.0", (Object)UncertaintyPackage.eINSTANCE);
            Resource resource = rs.getResource(this.createModelURI(), true);
            EcoreUtil.resolveAll((ResourceSet)rs);
            return (UncertaintyRepository)resource.getContents().get(0);
        }

        private URI createModelURI() {
            return URI.createURI((String)this.uncertaintyRepository);
        }

        private void requireValidString(String value) {
            Objects.requireNonNull(value, String.format("%s must not be null.", value));
            if (value.isBlank()) {
                throw new IllegalArgumentException(String.format("%s must not be blank.", value));
            }
        }
    }
}

