/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs;

import com.google.common.collect.Lists;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionContext;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionRunJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResult;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.PredictionResultFormatting;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class CsvResultExportJob
extends ReliabilityPredictionRunJob {
    private static final Logger LOGGER = Logger.getLogger((String)CsvResultExportJob.class.getName());
    private static final String CSV_DELIMITER = ";";

    public CsvResultExportJob(ReliabilityPredictionContext context) {
        super(context);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        URI exportFile = this.context.exportLocation.appendSegment("ReliabilityPredictionResults.csv");
        try {
            OutputStream output = new ExtensibleURIConverterImpl().createOutputStream(exportFile);
            this.appendHeader(output);
            this.appendResults(output);
            output.close();
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Reliability prediction results could not be written.", (Throwable)e);
        }
    }

    private void appendHeader(OutputStream output) throws IOException {
        String uncertaintyColumn = "Uncertainty";
        String probOfSuccessColumn = "Prob of Success";
        String probOfFailureColumn = "Prob of Failure";
        String condProbOfSuccessColumn = "Cond Prob of Success";
        String condProbOfFailureColumn = "Cond Prob of Failure";
        String probOfUncertaintyColumn = "Prob of Uncertainties";
        ArrayList header = Lists.newArrayList((Object[])new String[]{uncertaintyColumn, probOfSuccessColumn, probOfFailureColumn, condProbOfSuccessColumn, condProbOfFailureColumn, probOfUncertaintyColumn});
        this.writeRow(output, header);
    }

    private void appendResults(OutputStream output) throws IOException {
        UsageModel usageModel = ((PCMResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition")).getUsageModel();
        for (UsageScenario each : usageModel.getUsageScenario_UsageModel()) {
            this.appendRow(each, output);
        }
    }

    private void appendRow(UsageScenario scenario, OutputStream output) throws IOException {
        ReliabilityPredictionResult result = this.context.result;
        Iterator<ReliabilityPredictionResultPerScenario> iterator = PredictionResultFormatting.sortByUncertainties(result.filterPredictionResultsFor(scenario));
        while (iterator.hasNext()) {
            ReliabilityPredictionResultPerScenario next = iterator.next();
            ArrayList values = Lists.newArrayList();
            String uncertainties = PredictionResultFormatting.asString(next.getUncertainties());
            values.add(uncertainties);
            double probOfSuccess = result.getProbabilityOfSuccess(scenario);
            values.add(Double.toString(probOfSuccess));
            double probOfFailure = result.getProbabilityOfFailure(scenario);
            values.add(Double.toString(probOfFailure));
            double condProbOfSuccess = next.getConditionalProbabilityOfSuccess();
            values.add(Double.toString(condProbOfSuccess));
            double condProbOfFailure = next.getConditionalProbabilityOfFailure();
            values.add(Double.toString(condProbOfFailure));
            double probOfUncertainties = next.getProbabilityOfUncertainty();
            values.add(Double.toString(probOfUncertainties));
            this.writeRow(output, values);
        }
    }

    private void writeRow(OutputStream output, List<String> values) throws IOException {
        String row = String.join((CharSequence)CSV_DELIMITER, values).concat("\n");
        output.write(row.getBytes());
    }
}

