/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPrediction;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPredictionConfig;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionContext;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionRunJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResult;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class ReliabilityPredictionExecutionJob
extends ReliabilityPredictionRunJob {
    private final IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry;
    private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
    private final ParameterParser parameterParser;
    private final IProbabilityDistributionRepositoryLookup probDistRepoLookup;
    private final Optional<ISeedProvider> seedProvider;

    public ReliabilityPredictionExecutionJob(ReliabilityPredictionContext context, IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
        super(context);
        this.probabilityDistributionRegistry = probabilityDistributionRegistry;
        this.probabilityDistributionFactory = probabilityDistributionFactory;
        this.parameterParser = parameterParser;
        this.probDistRepoLookup = probDistRepoLookup;
        this.seedProvider = seedProvider;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ReliabilityPredictionResult result;
        UncertaintyBasedReliabilityPredictionConfig runConfig = UncertaintyBasedReliabilityPredictionConfig.newBuilder().withReliabilityRunConfig(this.context.config).andPcmModels((MDSDBlackboard)this.getBlackboard()).exploreStateSpaceWith(this.context.explorationStrategy).build();
        this.context.result = result = UncertaintyBasedReliabilityPrediction.predict(runConfig, this.probabilityDistributionRegistry, this.probabilityDistributionFactory, this.parameterParser, this.probDistRepoLookup, this.seedProvider);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return ReliabilityPredictionExecutionJob.class.getName();
    }
}

