/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionContext;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.ReliabilityPredictionRunJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResult;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.PredictionResultFormatting;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class ReliabilityPredictionResultVisualizationJob
extends ReliabilityPredictionRunJob {
    public ReliabilityPredictionResultVisualizationJob(ReliabilityPredictionContext context) {
        super(context);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        UsageModel usageModel = ((PCMResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition")).getUsageModel();
        usageModel.getUsageScenario_UsageModel().forEach(this::visualize);
    }

    private void visualize(UsageScenario scenario) {
        ReliabilityPredictionResult result = this.context.result;
        System.out.println(String.format("Scenario: %s", scenario.getEntityName()));
        int maxCharNum = result.filterPredictionResultsFor(scenario).stream().mapToInt(each -> PredictionResultFormatting.asString(each.getUncertainties()).length()).max().getAsInt();
        String leftAlignFormat = "| %-".concat(Integer.toString(maxCharNum)).concat("s | %-15f | %-15f | %-20f | %-20f | %-20f |%n");
        String lines = "-".repeat(maxCharNum - "Uncertainty".length() + 1);
        String blanks = " ".repeat(maxCharNum - "Uncertainty".length() + 1);
        System.out.format("+------------%s+-----------------+-----------------+----------------------+----------------------+----------------------+%n", lines);
        System.out.format("| Uncertainty%s| Prob of Success | Prob of Failure | Cond Prob of Success | Cond Prob of Failure | Prob of Uncertanties |%n", blanks);
        System.out.format("+------------%s+-----------------+-----------------+----------------------+----------------------+----------------------+%n", lines);
        Iterator<ReliabilityPredictionResultPerScenario> iterator = PredictionResultFormatting.sortByUncertainties(result.filterPredictionResultsFor(scenario));
        while (iterator.hasNext()) {
            ReliabilityPredictionResultPerScenario next = iterator.next();
            System.out.format(leftAlignFormat, PredictionResultFormatting.asString(next.getUncertainties()), result.getProbabilityOfSuccess(scenario), result.getProbabilityOfFailure(scenario), next.getConditionalProbabilityOfSuccess(), next.getConditionalProbabilityOfFailure(), next.getProbabilityOfUncertainty());
        }
        System.out.format("+------------%s+-----------------+-----------------+----------------------+----------------------+----------------------+%n", lines);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return ReliabilityPredictionResultVisualizationJob.class.getName();
    }
}

