/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.markov;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyRepository;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.BruteForceExplorationStrategy;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResult;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.ReliabilityPredictionResultPerScenario;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.StateSpaceExplorationStrategy;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.markov.UncertaintyResolver;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModel;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModelManager;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.ArchitecturalCountermeasureOperator;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.ArchitecturalPreconditionUtil;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.reliability.solver.pcm2markov.Pcm2MarkovStrategy;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class UncertaintyBasedReliabilityPredictor {
    private final UncertaintyRepository uncertaintyRepo;
    private final PCMSolverWorkflowRunConfiguration config;
    private final StateSpaceExplorationStrategy exploreStrategy;
    private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
    private final ParameterParser parameterParser;
    private final Optional<ISeedProvider> seedProvider;
    private ArchitecturalCountermeasureOperator operator = null;

    private UncertaintyBasedReliabilityPredictor(StateSpaceExplorationStrategy exploreStrategy, PCMSolverWorkflowRunConfiguration config, UncertaintyRepository uncertaintyRepo, IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
        this.config = config;
        this.exploreStrategy = exploreStrategy;
        this.uncertaintyRepo = uncertaintyRepo;
        this.probabilityDistributionFactory = probabilityDistributionFactory;
        this.parameterParser = parameterParser;
        this.seedProvider = seedProvider;
        UncertaintyModelManager manager = UncertaintyModelManager.get();
        manager.reset();
        manager.manage((List<UncertaintyInducedFailureType>)uncertaintyRepo.getUncertaintyInducedFailureTypes(), probabilityDistributionFactory, parameterParser, seedProvider);
    }

    public static UncertaintyBasedReliabilityPredictionBuilder newBuilder(IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
        return new UncertaintyBasedReliabilityPredictionBuilder(probabilityDistributionRegistry, probabilityDistributionFactory, parameterParser, probDistRepoLookup, seedProvider);
    }

    public ReliabilityPredictionResult predictSuccessProbability(PCMInstance unresolved) {
        Objects.requireNonNull(this.exploreStrategy, "Cannot predict reliability when no evaluation strategy is selected.");
        ReliabilityPredictionResult result = new ReliabilityPredictionResult();
        this.getArchitecturalCountermeasureOperator(unresolved, this.probabilityDistributionFactory, this.parameterParser, this.seedProvider).applyToUncertaintyModels();
        DiscreteUncertaintyStateSpace stateSpace = UncertaintyModelManager.get().getStateSpace();
        for (List<DiscreteUncertaintyStateSpace.UncertaintyState> eachTuple : this.exploreStrategy.explore(stateSpace)) {
            Set<ReliabilityPredictionResultPerScenario> conditionalPoS = this.predict(unresolved, eachTuple);
            result.addAll(conditionalPoS);
        }
        return result;
    }

    public Set<ReliabilityPredictionResultPerScenario> predictConditionalSuccessProbability(PCMInstance unresolved, List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple) {
        List<DiscreteUncertaintyStateSpace.UncertaintyState> improved = this.getArchitecturalCountermeasureOperator(unresolved, this.probabilityDistributionFactory, this.parameterParser, this.seedProvider).applyToUncertainties(stateTuple);
        return this.predict(unresolved, improved);
    }

    private Set<ReliabilityPredictionResultPerScenario> predict(PCMInstance unresolved, List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple) {
        PCMInstance resolved = this.resolveUncertainties(unresolved, stateTuple);
        List<MarkovTransformationResult> conditionalPoS = this.predictProbabilityOfSuccessGiven(resolved);
        Double probOfUncertainties = this.predictProbabilityOfUncertainties(stateTuple, resolved);
        return conditionalPoS.stream().map(each -> ReliabilityPredictionResultPerScenario.of(each, stateTuple, probOfUncertainties)).collect(Collectors.toSet());
    }

    private PCMInstance resolveUncertainties(PCMInstance modelToResolve, List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple) {
        UncertaintyResolver uncertaintyResolver = new UncertaintyResolver(modelToResolve);
        this.uncertaintyRepo.getUncertaintyInducedFailureTypes().forEach(uncertainty -> uncertaintyResolver.resolve((UncertaintyInducedFailureType)uncertainty, stateTuple));
        return modelToResolve;
    }

    private List<MarkovTransformationResult> predictProbabilityOfSuccessGiven(PCMInstance pcmModel) {
        Pcm2MarkovStrategy solver = new Pcm2MarkovStrategy(this.config);
        solver.transform(pcmModel);
        return solver.getAllSolvedValues();
    }

    private Double predictProbabilityOfUncertainties(List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple, PCMInstance pcmModel) {
        double probOfUncertainties = 1.0;
        for (UncertaintyInducedFailureType each : this.uncertaintyRepo.getUncertaintyInducedFailureTypes()) {
            if (!ArchitecturalPreconditionUtil.allPreconditionsFulfilled(each, pcmModel)) continue;
            UncertaintyModel uncertaintyModel = UncertaintyModelManager.get().findModelFor(each).orElseThrow();
            probOfUncertainties *= uncertaintyModel.probability(stateTuple);
        }
        return probOfUncertainties;
    }

    private ArchitecturalCountermeasureOperator getArchitecturalCountermeasureOperator(PCMInstance unresolved, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        if (this.operator == null) {
            this.operator = ArchitecturalCountermeasureOperator.createOperatorFor(unresolved, this.uncertaintyRepo, probabilityDistributionFactory, parameterParser, seedProvider);
        }
        return this.operator;
    }

    public static class UncertaintyBasedReliabilityPredictionBuilder {
        private PCMSolverWorkflowRunConfiguration config = null;
        private StateSpaceExplorationStrategy exploreStrategy = null;
        private UncertaintyRepository uncertaintyRepo = null;
        private final IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry;
        private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
        private final ParameterParser parameterParser;
        private final IProbabilityDistributionRepositoryLookup probDistRepoLookup;
        private final Optional<ISeedProvider> seedProvider;

        public UncertaintyBasedReliabilityPredictionBuilder(IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
            this.probabilityDistributionRegistry = probabilityDistributionRegistry;
            this.probabilityDistributionFactory = probabilityDistributionFactory;
            this.parameterParser = parameterParser;
            this.probDistRepoLookup = probDistRepoLookup;
            this.seedProvider = seedProvider;
        }

        public UncertaintyBasedReliabilityPredictionBuilder withConfig(PCMSolverWorkflowRunConfiguration config) {
            this.config = config;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionBuilder bruteForceStateSpaceExploration() {
            this.exploreStrategy = new BruteForceExplorationStrategy();
            return this;
        }

        public UncertaintyBasedReliabilityPredictionBuilder exploreStateSpaceWith(StateSpaceExplorationStrategy strategy) {
            this.exploreStrategy = strategy;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionBuilder andUncertaintyRepo(UncertaintyRepository uncertaintyRepo) {
            this.uncertaintyRepo = uncertaintyRepo;
            return this;
        }

        public UncertaintyBasedReliabilityPredictor build() {
            this.checkValidity();
            this.adjustConfig();
            return new UncertaintyBasedReliabilityPredictor(this.exploreStrategy, this.config, this.uncertaintyRepo, this.probabilityDistributionRegistry, this.probabilityDistributionFactory, this.parameterParser, this.probDistRepoLookup, this.seedProvider);
        }

        private void checkValidity() {
            Objects.requireNonNull(this.config, "The reliability configuration is missing.");
            Objects.requireNonNull(this.uncertaintyRepo, "The uncertainty repository is missing.");
        }

        private void adjustConfig() {
            if (Objects.nonNull(this.exploreStrategy)) {
                this.config.setShowHtmlResults(false);
            }
        }
    }
}

