/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.markov;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModel;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModelManager;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.util.ArchitecturalPreconditionUtil;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.ReliabilityPackage;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.util.ReliabilitySwitch;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.EMFHelper;

public class UncertaintyResolver {
    private static final EMFHelper EMF_HELPER = new EMFHelper();
    private final PCMInstance pcmInstance;

    public UncertaintyResolver(PCMInstance pcmInstance) {
        this.pcmInstance = pcmInstance;
    }

    public void resolve(UncertaintyInducedFailureType uncertainty, List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        ProbabilityUpdater probabilityUpdater = new ProbabilityUpdater();
        for (FailureType each : this.filterFailureTypes(this.pcmInstance)) {
            if (!this.isRefined(each, uncertainty) || !this.isActive(uncertainty)) continue;
            probabilityUpdater.update(each, this.computeProbabilityOfFailure(uncertainty, values));
        }
    }

    private double computeProbabilityOfFailure(UncertaintyInducedFailureType uncertainty, List<DiscreteUncertaintyStateSpace.UncertaintyState> values) {
        UncertaintyModel uncertaintyModel = UncertaintyModelManager.get().findModelFor(uncertainty).orElseThrow();
        return uncertaintyModel.probabilityOfFailureGiven(values);
    }

    public PCMInstance getResolved() {
        return this.pcmInstance;
    }

    private List<FailureType> filterFailureTypes(PCMInstance pcmModel) {
        return pcmModel.getRepositories().stream().flatMap(each -> this.filterFailureTypes((Repository)each).stream()).collect(Collectors.toList());
    }

    private List<FailureType> filterFailureTypes(Repository root) {
        return EMF_HELPER.getElements((EObject)root, ReliabilityPackage.eINSTANCE.getFailureType()).stream().map(FailureType.class::cast).collect(Collectors.toList());
    }

    private boolean isActive(UncertaintyInducedFailureType uncertainty) {
        return ArchitecturalPreconditionUtil.allPreconditionsFulfilled(uncertainty, this.pcmInstance);
    }

    private boolean isRefined(FailureType failureType, UncertaintyInducedFailureType uncertainty) {
        return this.areEqual(uncertainty.getRefines(), failureType);
    }

    private boolean areEqual(FailureType first, FailureType second) {
        return first.getId().equals(second.getId());
    }

    private class ProbabilityUpdater {
        private ProbabilityUpdater() {
        }

        public void update(FailureType failureType, final double failureProb) {
            new ReliabilitySwitch<Boolean>(){

                public Boolean caseHardwareInducedFailureType(HardwareInducedFailureType object) {
                    ProbabilityUpdater.this.filterProcessingResourceSpecsWith(object).forEach(spec -> spec.setMTTF(failureProb));
                    return true;
                }

                public Boolean caseNetworkInducedFailureType(NetworkInducedFailureType object) {
                    ProbabilityUpdater.this.filterLinkingResourcesWith(object).forEach(link -> link.getCommunicationLinkResourceSpecifications_LinkingResource().setFailureProbability(failureProb));
                    return true;
                }

                public Boolean caseSoftwareInducedFailureType(SoftwareInducedFailureType object) {
                    ProbabilityUpdater.this.filterFailureOccurenceDescsWith(object).forEach(desc -> desc.setFailureProbability(failureProb));
                    return true;
                }
            }.doSwitch((EObject)failureType);
        }

        private List<ProcessingResourceSpecification> filterProcessingResourceSpecsWith(HardwareInducedFailureType failureType) {
            return UncertaintyResolver.this.pcmInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().flatMap(each -> each.getActiveResourceSpecifications_ResourceContainer().stream()).filter(this.describing(failureType)).collect(Collectors.toList());
        }

        private List<LinkingResource> filterLinkingResourcesWith(NetworkInducedFailureType failureType) {
            return UncertaintyResolver.this.pcmInstance.getResourceEnvironment().getLinkingResources__ResourceEnvironment().stream().filter(this.describing(failureType)).collect(Collectors.toList());
        }

        private List<FailureOccurrenceDescription> filterFailureOccurenceDescsWith(SoftwareInducedFailureType failureType) {
            ArrayList result = Lists.newArrayList();
            for (AssemblyContext eachAssemblyContext : UncertaintyResolver.this.pcmInstance.getSystem().getAssemblyContexts__ComposedStructure()) {
                RepositoryComponent instantiated = eachAssemblyContext.getEncapsulatedComponent__AssemblyContext();
                if (!(instantiated instanceof BasicComponent)) continue;
                EList seffs = ((BasicComponent)BasicComponent.class.cast(instantiated)).getServiceEffectSpecifications__BasicComponent();
                for (ServiceEffectSpecification eachSeff : seffs) {
                    List descs = this.filterFailureOccurenceDescs(eachSeff).stream().filter(this.describing(failureType)).collect(Collectors.toList());
                    if (descs.isEmpty()) continue;
                    result.addAll(descs);
                }
            }
            return result;
        }

        private Predicate<ProcessingResourceSpecification> describing(HardwareInducedFailureType searchedFailureType) {
            return spec -> spec.getActiveResourceType_ActiveResourceSpecification().getId().equals(searchedFailureType.getProcessingResourceType__HardwareInducedFailureType().getId());
        }

        private Predicate<LinkingResource> describing(NetworkInducedFailureType searchedFailureType) {
            return link -> link.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getId().equals(searchedFailureType.getCommunicationLinkResourceType__NetworkInducedFailureType().getId());
        }

        private Predicate<FailureOccurrenceDescription> describing(SoftwareInducedFailureType searchedFailureType) {
            return desc -> {
                Object describedFailure = null;
                describedFailure = InternalFailureOccurrenceDescription.class.isInstance(desc) ? ((InternalFailureOccurrenceDescription)InternalFailureOccurrenceDescription.class.cast(desc)).getSoftwareInducedFailureType__InternalFailureOccurrenceDescription() : ((ExternalFailureOccurrenceDescription)ExternalFailureOccurrenceDescription.class.cast(desc)).getFailureType__ExternalFailureOccurrenceDescription();
                return UncertaintyResolver.this.areEqual((FailureType)describedFailure, (FailureType)searchedFailureType);
            };
        }

        private List<FailureOccurrenceDescription> filterFailureOccurenceDescs(ServiceEffectSpecification root) {
            return EMF_HELPER.getElements((EObject)root, ReliabilityPackage.eINSTANCE.getFailureOccurrenceDescription()).stream().map(FailureOccurrenceDescription.class::cast).collect(Collectors.toList());
        }
    }
}

