/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;

public class UncertaintyModelUtil {
    public static Set<GroundRandomVariable> filterRandomVariablesOnlyWithParent(GroundProbabilisticNetwork network) {
        Set<GroundRandomVariable> withParents = UncertaintyModelUtil.filterRandomVariablesWithParent(network);
        Set<GroundRandomVariable> withoutChilds = UncertaintyModelUtil.filterRandomVariablesWithoutChilds(network);
        return Sets.intersection(withParents, withoutChilds);
    }

    public static Set<GroundRandomVariable> filterRandomVariablesWithParent(GroundProbabilisticNetwork network) {
        return network.getLocalProbabilisticModels().stream().flatMap(each -> each.getGroundRandomVariables().stream()).filter(UncertaintyModelUtil.variablesWithParents()).collect(Collectors.toSet());
    }

    public static Set<GroundRandomVariable> filterRandomVariablesWithoutChilds(GroundProbabilisticNetwork network) {
        Set allVariables = network.getLocalProbabilisticModels().stream().flatMap(each -> each.getGroundRandomVariables().stream()).collect(Collectors.toSet());
        Set dependencies = allVariables.stream().flatMap(each -> each.getDependenceStructure().stream()).collect(Collectors.toSet());
        HashSet result = Sets.newHashSet();
        for (GroundRandomVariable each2 : allVariables) {
            if (!dependencies.stream().allMatch(d -> !d.getSource().getId().equals(each2.getInstantiatedTemplate().getId()))) continue;
            result.add(each2);
        }
        return result;
    }

    private static Predicate<GroundRandomVariable> variablesWithParents() {
        return v -> !v.getDependenceStructure().isEmpty();
    }
}

