/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.ICompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.core.jobs.LoadModelIntoBlackboardJob;
import org.palladiosimulator.analyzer.workflow.jobs.EventsTransformationJob;
import org.palladiosimulator.analyzer.workflow.jobs.ValidatePCMModelsJob;
import org.palladiosimulator.architecturaltemplates.jobs.RunATJob;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionConfigurationBuilder;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.PCMInstanceBuilderJob;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.RootReliabilityPredictionRunJob;
import org.palladiosimulator.experimentautomation.application.jobs.PrepareBlackboardJob;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class UncertaintyBasedReliabilityPredictionJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements ICompositeJob {
    public static UncertaintyBasedReliabilityPredictionJobBuilder newBuilder(IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
        return new UncertaintyBasedReliabilityPredictionJobBuilder(probabilityDistributionRegistry, probabilityDistributionFactory, parameterParser, probDistRepoLookup, seedProvider);
    }

    public static class UncertaintyBasedReliabilityPredictionJobBuilder {
        private PCMSolverWorkflowRunConfiguration config = null;
        private String uncertaintyModel = "";
        private String explorationStrategy = "";
        private boolean applyATs = false;
        private ILaunchConfiguration launchConfig = null;
        private Optional<String> exportLocation = Optional.empty();
        private final IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry;
        private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
        private final ParameterParser parameterParser;
        private final IProbabilityDistributionRepositoryLookup probDistRepoLookup;
        private final Optional<ISeedProvider> seedProvider;

        public UncertaintyBasedReliabilityPredictionJobBuilder(IProbabilityDistributionRegistry<CategoricalValue> probabilityDistributionRegistry, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, IProbabilityDistributionRepositoryLookup probDistRepoLookup, Optional<ISeedProvider> seedProvider) {
            this.probabilityDistributionRegistry = probabilityDistributionRegistry;
            this.probabilityDistributionFactory = probabilityDistributionFactory;
            this.parameterParser = parameterParser;
            this.probDistRepoLookup = probDistRepoLookup;
            this.seedProvider = seedProvider;
        }

        public UncertaintyBasedReliabilityPredictionJobBuilder withConfig(PCMSolverWorkflowRunConfiguration config) {
            this.config = config;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionJobBuilder andUncertaintyModel(String uncertaintyModel) {
            this.uncertaintyModel = uncertaintyModel;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionJobBuilder andExplorationStrategy(String explorationStrategy) {
            this.explorationStrategy = explorationStrategy;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionJobBuilder applyArchitecturalTemplates(ILaunchConfiguration launchConfig) {
            this.launchConfig = launchConfig;
            this.applyATs = true;
            return this;
        }

        public UncertaintyBasedReliabilityPredictionJobBuilder exportResults(String exportLocation) {
            this.exportLocation = Optional.ofNullable(exportLocation);
            return this;
        }

        public UncertaintyBasedReliabilityPredictionJob build() {
            Optional<URI> exportLocationURI;
            UncertaintyBasedReliabilityPredictionJob relPredictionJob = new UncertaintyBasedReliabilityPredictionJob();
            relPredictionJob.myBlackboard = (Blackboard)new MDSDBlackboard();
            Objects.requireNonNull(this.config, "The reliability config must be specified.");
            PCMInstanceBuilderJob pcmInstanceBuilderJob = new PCMInstanceBuilderJob(this.config);
            relPredictionJob.addJob((IJob)pcmInstanceBuilderJob);
            relPredictionJob.addJob((IJob)new LoadModelIntoBlackboardJob(URI.createURI((String)this.uncertaintyModel), "org.palladiosimulator.pcmmodels.partition"));
            relPredictionJob.addJob((IJob)new PrepareBlackboardJob());
            if (this.applyATs) {
                this.addATJob(relPredictionJob);
            }
            relPredictionJob.addJob((IJob)new ValidatePCMModelsJob((AbstractPCMWorkflowRunConfiguration)this.config));
            relPredictionJob.addJob((IJob)new EventsTransformationJob(this.config.getStoragePluginID(), this.config.getEventMiddlewareFile(), false));
            if (this.exportLocation.isEmpty()) {
                exportLocationURI = Optional.empty();
            } else {
                URI uri = URI.createURI((String)this.exportLocation.get());
                exportLocationURI = Optional.of(uri);
            }
            relPredictionJob.addJob((IJob)new RootReliabilityPredictionRunJob(this.config, this.uncertaintyModel, this.explorationStrategy, exportLocationURI, this.probabilityDistributionRegistry, this.probabilityDistributionFactory, this.parameterParser, this.probDistRepoLookup, this.seedProvider));
            return relPredictionJob;
        }

        private void addATJob(UncertaintyBasedReliabilityPredictionJob rootJob) {
            RunATJob atJob = new RunATJob();
            ATExtensionConfigurationBuilder jobConfigurationBuilder = new ATExtensionConfigurationBuilder();
            try {
                atJob.setJobConfiguration(jobConfigurationBuilder.buildConfiguration(this.launchConfig.getAttributes()));
            }
            catch (CoreException e) {
                throw new RuntimeException("Launch configuration has no attributes.");
            }
            rootJob.addJob((IJob)atJob);
        }
    }
}

