/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.markov;

import java.util.List;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovTransformationResult;

public class ReliabilityPredictionResultPerScenario {
    private final UsageScenario usageScenario;
    private final List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple;
    private final double probabilityOfSuccess;
    private final double probabilityOfUncertainties;

    private ReliabilityPredictionResultPerScenario(MarkovTransformationResult markovResult, List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple, double probabilityOfUncertainties) {
        this.usageScenario = markovResult.getScenario();
        this.stateTuple = stateTuple;
        this.probabilityOfSuccess = markovResult.getSuccessProbability();
        this.probabilityOfUncertainties = probabilityOfUncertainties;
    }

    public static ReliabilityPredictionResultPerScenario of(MarkovTransformationResult results, List<DiscreteUncertaintyStateSpace.UncertaintyState> stateTuple, double probabilityOfUncertainties) {
        return new ReliabilityPredictionResultPerScenario(results, stateTuple, probabilityOfUncertainties);
    }

    public UsageScenario getUsageScenario() {
        return this.usageScenario;
    }

    public List<DiscreteUncertaintyStateSpace.UncertaintyState> getUncertainties() {
        return this.stateTuple;
    }

    public double getProbabilityOfUncertainty() {
        return this.probabilityOfUncertainties;
    }

    public double getConditionalProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double getConditionalProbabilityOfFailure() {
        return 1.0 - this.probabilityOfSuccess;
    }

    public double getJoinedSuccessAndUncertaintyProbability() {
        return this.getConditionalProbabilityOfSuccess() * this.getProbabilityOfUncertainty();
    }

    public double getJoinedFailureAndUncertaintyProbability() {
        return this.getProbabilityOfUncertainty() - this.getJoinedSuccessAndUncertaintyProbability();
    }
}

