/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributionfunction.TabularCPD;
import tools.mdsd.probdist.distributionfunction.TabularCPDEntry;

public class DiscreteUncertaintyStateSpace {
    private final List<UncertaintyState> states;

    private DiscreteUncertaintyStateSpace(List<UncertaintyState> states) {
        this.states = this.mergeToDistinctStates(states);
    }

    private List<UncertaintyState> mergeToDistinctStates(List<UncertaintyState> states) {
        ArrayList distinctStates = Lists.newArrayList();
        for (UncertaintyState each : states) {
            if (!distinctStates.stream().noneMatch(s -> s.valueSpaceIsEqual(each))) continue;
            distinctStates.add(each);
        }
        return distinctStates;
    }

    public static DiscreteUncertaintyStateSpace of(UncertaintyState ... uncertaintyStates) {
        return new DiscreteUncertaintyStateSpace(Lists.newArrayList((Object[])uncertaintyStates));
    }

    public static DiscreteUncertaintyStateSpace of(List<UncertaintyState> uncertaintyStates) {
        return new DiscreteUncertaintyStateSpace(uncertaintyStates);
    }

    public static Set<UncertaintyState> valueSpaceOf(UncertaintyInducedFailureType uncertainty, ParameterParser parameterParser) {
        GroundProbabilisticNetwork groundNetwork = uncertainty.getUncertaintyModel();
        if (groundNetwork.getLocalProbabilisticModels().size() != 1) {
            throw new IllegalArgumentException("The bayesian network must include only one local network.");
        }
        return DiscreteUncertaintyStateSpace.deriveUncertaintyStates((LocalProbabilisticNetwork)groundNetwork.getLocalProbabilisticModels().get(0), parameterParser);
    }

    private static Set<UncertaintyState> deriveUncertaintyStates(LocalProbabilisticNetwork localNetwork, ParameterParser parameterParser) {
        return localNetwork.getGroundRandomVariables().stream().map(c -> DiscreteUncertaintyStateSpace.toUncertaintyState(c, parameterParser)).collect(Collectors.toSet());
    }

    public static UncertaintyState toUncertaintyState(GroundRandomVariable variable, ParameterParser parameterParser) {
        ProbabilityDistribution probDist = variable.getDescriptiveModel().getDistribution();
        if (probDist.getParams().size() != 1) {
            throw new IllegalArgumentException("The distribution is not valid for this operation.");
        }
        ParamRepresentation param = ((Parameter)probDist.getParams().get(0)).getRepresentation();
        return UncertaintyState.of(variable, DiscreteUncertaintyStateSpace.getValueSpace(param, parameterParser));
    }

    private static Set<CategoricalValue> getValueSpace(ParamRepresentation param, ParameterParser parameterParser) {
        if (SimpleParameter.class.isInstance(param)) {
            return DiscreteUncertaintyStateSpace.getValueSpace((SimpleParameter)SimpleParameter.class.cast(param), parameterParser);
        }
        if (TabularCPD.class.isInstance(param)) {
            TabularCPDEntry any = (TabularCPDEntry)((TabularCPD)TabularCPD.class.cast(param)).getCpdEntries().get(0);
            return DiscreteUncertaintyStateSpace.getValueSpace(any.getEntry(), parameterParser);
        }
        throw new IllegalArgumentException("The distribution parameter type is not proper in this context.");
    }

    private static Set<CategoricalValue> getValueSpace(SimpleParameter param, ParameterParser parameterParser) {
        Set samples = parameterParser.parseSampleSpace(param);
        return samples.stream().map(each -> each.value).collect(Collectors.toSet());
    }

    public Set<List<UncertaintyState>> cartesianProduct() {
        return Sets.cartesianProduct(this.getStateSpace()).stream().map(this.enrichWithValues()).collect(Collectors.toSet());
    }

    public Optional<UncertaintyState> findStateInstantiating(TemplateVariable template) {
        return this.states.stream().filter(each -> each.instantiates(template)).findFirst();
    }

    public int getNumberOfStates() {
        return this.states.size();
    }

    private List<Set<CategoricalValue>> getStateSpace() {
        return this.states.stream().map(each -> each.getValueSpace()).collect(Collectors.toList());
    }

    private Function<List<CategoricalValue>, List<UncertaintyState>> enrichWithValues() {
        return values -> {
            ArrayList valuedStates = Lists.newArrayList();
            int i = 0;
            while (i < this.states.size()) {
                UncertaintyState valuedState = this.states.get(i).newValuedStateWith((CategoricalValue)values.get(i));
                valuedStates.add(valuedState);
                ++i;
            }
            return valuedStates;
        };
    }

    public static class UncertaintyState {
        private final GroundRandomVariable variable;
        private final Set<CategoricalValue> valueSpace;
        private final CategoricalValue value;

        private UncertaintyState(UncertaintyState state, CategoricalValue value) {
            this.variable = state.variable;
            this.valueSpace = state.valueSpace;
            this.value = value;
        }

        private UncertaintyState(GroundRandomVariable variable, Set<CategoricalValue> valueSpace) {
            this.variable = variable;
            this.valueSpace = valueSpace;
            this.value = null;
        }

        public static UncertaintyState of(GroundRandomVariable variable, Set<CategoricalValue> valueSpace) {
            return new UncertaintyState(variable, valueSpace);
        }

        public UncertaintyState newValuedStateWith(CategoricalValue value) {
            return new UncertaintyState(this, value);
        }

        public String getId() {
            return this.variable.getEntityName();
        }

        public Set<CategoricalValue> getValueSpace() {
            return this.valueSpace;
        }

        public CategoricalValue getValue() {
            return this.value;
        }

        public boolean instantiates(TemplateVariable template) {
            return this.getInstantiatedTemplate().getId().equals(template.getId());
        }

        public TemplateVariable getInstantiatedTemplate() {
            return this.variable.getInstantiatedTemplate();
        }

        private boolean valueSpaceIsEqual(UncertaintyState state) {
            if (state.valueSpace.size() != this.valueSpace.size()) {
                return false;
            }
            HashSet copy = Sets.newHashSet(this.valueSpace);
            for (CategoricalValue each : state.valueSpace) {
                copy.removeIf(v -> ((String)v.get()).equals(each.get()));
            }
            return copy.isEmpty();
        }
    }
}

