/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.model;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.BayesianUncertaintyModel;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.DiscreteUncertaintyStateSpace;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.MLInducedUncertaintyModel;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.model.UncertaintyModel;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.api.random.ISeedProvider;

public class UncertaintyModelManager {
    private static UncertaintyModelManager managerInstance = null;
    private final Map<String, UncertaintyModel> managedModels = Maps.newHashMap();

    private UncertaintyModelManager() {
    }

    public static UncertaintyModelManager get() {
        if (Objects.isNull(managerInstance)) {
            managerInstance = new UncertaintyModelManager();
        }
        return managerInstance;
    }

    public void reset() {
        this.managedModels.clear();
    }

    public void updateModel(UncertaintyInducedFailureType uncertainty, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        if (this.findModelFor(uncertainty).isPresent()) {
            this.manage(uncertainty, probabilityDistributionFactory, parameterParser, seedProvider);
        }
    }

    public Optional<UncertaintyModel> findModelFor(UncertaintyInducedFailureType uncertainty) {
        return Optional.ofNullable(this.managedModels.get(uncertainty.getId()));
    }

    public DiscreteUncertaintyStateSpace getStateSpace() {
        this.managedModels.forEach((k, v) -> System.out.println(String.valueOf(k.toString()) + ", " + v.toString()));
        List<DiscreteUncertaintyStateSpace.UncertaintyState> states = this.managedModels.values().stream().flatMap(m -> m.getValueSpace().stream()).collect(Collectors.toList());
        return DiscreteUncertaintyStateSpace.of(states);
    }

    public void manage(List<UncertaintyInducedFailureType> uncertainties, final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, final ParameterParser parameterParser, final Optional<ISeedProvider> seedProvider) {
        Consumer<UncertaintyInducedFailureType> consumer = new Consumer<UncertaintyInducedFailureType>(){

            @Override
            public void accept(UncertaintyInducedFailureType failureType) {
                UncertaintyModelManager.this.manage(failureType, (IProbabilityDistributionFactory<CategoricalValue>)probabilityDistributionFactory, parameterParser, (Optional<ISeedProvider>)seedProvider);
            }
        };
        uncertainties.forEach(consumer);
    }

    public void manage(UncertaintyInducedFailureType failureType, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, ParameterParser parameterParser, Optional<ISeedProvider> seedProvider) {
        if (Objects.isNull(failureType.getFailureVariable())) {
            this.managedModels.put(failureType.getId(), new MLInducedUncertaintyModel(failureType, probabilityDistributionFactory, parameterParser, seedProvider));
        } else {
            this.managedModels.put(failureType.getId(), new BayesianUncertaintyModel(failureType, probabilityDistributionFactory, parameterParser));
        }
    }
}

