/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.solver.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalCountermeasure;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalPrecondition;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyInducedFailureType;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ArchitecturalPreconditionChecker;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ArchitecturalPreconditionManager;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class ArchitecturalPreconditionUtil {
    public static boolean allPreconditionsFulfilled(ArchitecturalCountermeasure countermeasure, PCMInstance pcmModel) {
        return countermeasure.getArchitecturalPreconditions().stream().allMatch(ArchitecturalPreconditionUtil.isFulfilled(pcmModel));
    }

    public static boolean allPreconditionsFulfilled(UncertaintyInducedFailureType uncertainty, PCMInstance pcmModel) {
        return uncertainty.getArchitecturalPreconditions().stream().allMatch(ArchitecturalPreconditionUtil.isFulfilled(pcmModel));
    }

    private static Predicate<ArchitecturalPrecondition> isFulfilled(PCMInstance pcmModel) {
        return precondition -> {
            Optional checker = ArchitecturalPreconditionManager.get().findPreconditionCheckerFor(precondition);
            if (checker.isPresent()) {
                return ((ArchitecturalPreconditionChecker)checker.get()).isFulfilled(pcmModel, precondition);
            }
            return false;
        };
    }
}

