/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.ui.launch;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.api.UncertaintyBasedReliabilityPrediction;

public class ReliabilityPredictionOptionsTab
extends AbstractLaunchConfigurationTab {
    private static final String[] RESTRICTIONS = new String[]{"*.uncertainty"};
    private Text uncertaintyModelLocation;
    private Combo supportedStrategiesCombobox;
    private Button atButton;
    private Button exportResultsButton;
    private Text exportLocationFile;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ReliabilityPredictionOptionsTab.this.updateTab();
        }
    };

    private void updateTab() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        Composite container = this.createRootContainer(parent);
        this.createUncertaintyModelLocationText(container);
        this.createSupportedExplorationStrategiesGroup(container);
        this.createArchitecturalTemplateGroup(container);
        this.createExportResultsGroup(container);
    }

    private Composite createRootContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().applyTo(container);
        return container;
    }

    private void createUncertaintyModelLocationText(Composite container) {
        this.uncertaintyModelLocation = new Text(container, 2052);
        TabHelper.createFileInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"Uncertainty model location", (String[])RESTRICTIONS, (Text)this.uncertaintyModelLocation, (Shell)this.getShell(), (String)"");
    }

    private void createSupportedExplorationStrategiesGroup(Composite container) {
        Group mlModelsGroup = new Group(container, 0);
        mlModelsGroup.setText("State space exploration strategy selection");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)mlModelsGroup);
        Label mlModelLabel = new Label((Composite)mlModelsGroup, 0);
        mlModelLabel.setText("Supported strategies:");
        GridDataFactory.swtDefaults().applyTo((Control)mlModelLabel);
        this.supportedStrategiesCombobox = new Combo((Composite)mlModelsGroup, 8);
        this.supportedStrategiesCombobox.setItems(this.getStrategyNames());
        this.supportedStrategiesCombobox.setSize(400, 200);
        this.supportedStrategiesCombobox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ReliabilityPredictionOptionsTab.this.updateTab();
            }
        });
    }

    private void createArchitecturalTemplateGroup(Composite container) {
        Group atGroup = new Group(container, 0);
        atGroup.setText("Architectural templates");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)atGroup);
        this.atButton = new Button((Composite)atGroup, 32);
        this.atButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.atButton.setText("Apply architectural templates, if any");
        this.atButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ReliabilityPredictionOptionsTab.this.updateTab();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ReliabilityPredictionOptionsTab.this.updateTab();
            }
        });
    }

    private void createExportResultsGroup(Composite container) {
        Group exportResultsGroup = new Group(container, 0);
        exportResultsGroup.setText("Result export");
        GridData gd = new GridData(4, 0x1000000, true, false);
        exportResultsGroup.setLayoutData((Object)gd);
        exportResultsGroup.setLayout((Layout)new GridLayout());
        this.exportResultsButton = new Button((Composite)exportResultsGroup, 32);
        this.exportResultsButton.setLayoutData((Object)gd);
        this.exportResultsButton.setText("Export results of reliability prediction");
        this.exportResultsButton.setSelection(false);
        this.exportResultsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ReliabilityPredictionOptionsTab.this.updateTab();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ReliabilityPredictionOptionsTab.this.updateTab();
            }
        });
        this.exportLocationFile = new Text((Composite)exportResultsGroup, 2052);
        this.exportLocationFile.setLayoutData((Object)gd);
        this.exportLocationFile.addModifyListener(this.modifyListener);
        TabHelper.createFolderInputSection((Composite)exportResultsGroup, (ModifyListener)this.modifyListener, (String)"Export location:", (Text)this.exportLocationFile, (String)"Export location:", (Shell)this.getShell(), (String)"");
    }

    private String[] getStrategyNames() {
        Set strategies = UncertaintyBasedReliabilityPrediction.getSupportedStrategies();
        String[] strategiesAsArray = new String[strategies.size()];
        return strategies.toArray(strategiesAsArray);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.strategy", "");
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.model", "");
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.at", false);
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export", false);
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export.file", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.uncertaintyModelLocation.setText(configuration.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.model", ""));
            this.supportedStrategiesCombobox.select(0);
            String expAttr = configuration.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.strategy", "");
            int i = 0;
            while (i < this.supportedStrategiesCombobox.getItemCount()) {
                String item = this.supportedStrategiesCombobox.getItem(i);
                if (item.equals(expAttr)) {
                    this.supportedStrategiesCombobox.select(i);
                    break;
                }
                ++i;
            }
            this.atButton.setSelection(configuration.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.at", false));
            this.exportResultsButton.setSelection(configuration.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export", false));
            this.exportLocationFile.setText(configuration.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export.file", ""));
        }
        catch (CoreException e) {
            this.uncertaintyModelLocation.setText("");
            this.supportedStrategiesCombobox.select(0);
            this.atButton.setSelection(false);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.strategy", this.supportedStrategiesCombobox.getItem(this.supportedStrategiesCombobox.getSelectionIndex()));
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.model", this.uncertaintyModelLocation.getText());
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.at", this.atButton.getSelection());
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export", this.exportResultsButton.getSelection());
        configuration.setAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export.file", this.exportLocationFile.getText());
    }

    public String getName() {
        return "Uncertainty based reliability prediction options";
    }
}

