/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.ui.launch;

import de.uka.ipd.sdq.workflow.jobs.IJob;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.palladiosimulator.dependability.reliability.uncertainty.solver.jobs.UncertaintyBasedReliabilityPredictionJob;
import org.palladiosimulator.reliability.solver.runconfig.PCMSolverReliabilityLaunchConfigurationDelegate;
import org.palladiosimulator.solver.core.runconfig.PCMSolverWorkflowRunConfiguration;
import tools.mdsd.probdist.api.apache.util.IProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.apache.util.ProbabilityDistributionRepositoryLookup;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionRegistry;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionFactory;
import tools.mdsd.probdist.api.parser.DefaultParameterParser;
import tools.mdsd.probdist.api.parser.ParameterParser;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionRepository;
import tools.mdsd.probdist.model.basic.loader.BasicDistributionTypesLoader;

public class ReliabilityPredictionLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        new ReliabilityPredictionLaunchConfigurationInnerDelegate(configuration).launch(configuration, mode, launch, monitor);
    }

    private class ReliabilityPredictionLaunchConfigurationInnerDelegate
    extends PCMSolverReliabilityLaunchConfigurationDelegate {
        private final ILaunchConfiguration launchConfig;

        public ReliabilityPredictionLaunchConfigurationInnerDelegate(ILaunchConfiguration launchConfig) {
            this.launchConfig = launchConfig;
        }

        protected IJob createWorkflowJob(PCMSolverWorkflowRunConfiguration config, ILaunch launch) throws CoreException {
            boolean exportResults;
            ProbabilityDistributionFactory defaultProbabilityDistributionFactory;
            String uncertaintyModelLocation = "";
            String explorationStrategy = "";
            try {
                uncertaintyModelLocation = this.launchConfig.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.model", "");
                explorationStrategy = this.launchConfig.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.strategy", "");
            }
            catch (CoreException e) {
                throw new RuntimeException(String.format("The attributes %1s and %2s are not available.", "org.palladiosimulator.dependability.reliability.uncertainty.ui.model", "org.palladiosimulator.dependability.reliability.uncertainty.ui.strategy"));
            }
            DefaultParameterParser parameterParser = new DefaultParameterParser();
            ProbabilityDistributionFactory probabilityDistributionRegistry = defaultProbabilityDistributionFactory = new ProbabilityDistributionFactory(Optional.empty());
            ProbabilityDistributionFactory probabilityDistributionFactory = defaultProbabilityDistributionFactory;
            ProbabilityDistributionRepository probabilityDistributionRepository = BasicDistributionTypesLoader.loadRepository();
            ProbabilityDistributionRepositoryLookup probDistRepoLookup = new ProbabilityDistributionRepositoryLookup(probabilityDistributionRepository);
            Optional seedProvider = Optional.empty();
            UncertaintyBasedReliabilityPredictionJob.UncertaintyBasedReliabilityPredictionJobBuilder jobBuilder = UncertaintyBasedReliabilityPredictionJob.newBuilder((IProbabilityDistributionRegistry)probabilityDistributionRegistry, (IProbabilityDistributionFactory)probabilityDistributionFactory, (ParameterParser)parameterParser, (IProbabilityDistributionRepositoryLookup)probDistRepoLookup, seedProvider).withConfig(config).andUncertaintyModel(uncertaintyModelLocation).andExplorationStrategy(explorationStrategy);
            boolean applyATs = this.launchConfig.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.at", false);
            if (applyATs) {
                jobBuilder.applyArchitecturalTemplates(this.launchConfig);
            }
            if (exportResults = this.launchConfig.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export", false)) {
                String exportLocation = this.launchConfig.getAttribute("org.palladiosimulator.dependability.reliability.uncertainty.ui.export.file", "");
                jobBuilder.exportResults(exportLocation);
            }
            return jobBuilder.build();
        }
    }
}

