/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.precondition;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.palladiosimulator.dependability.reliability.uncertainty.ActiveComponent;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalPrecondition;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ArchitecturalPreconditionChecker;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingRequiringEntity;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class ActiveComponentChecker
implements ArchitecturalPreconditionChecker {
    protected ActiveComponentChecker() {
    }

    @Override
    public boolean isApplicable(ArchitecturalPrecondition precondition) {
        return precondition instanceof ActiveComponent;
    }

    @Override
    public boolean isFulfilled(PCMInstance pcmModel, ArchitecturalPrecondition precondition) {
        if (this.isNotApplicable(precondition)) {
            return false;
        }
        InterfaceProvidingRequiringEntity requiredActiveComponent = ((ActiveComponent)ActiveComponent.class.cast(precondition)).getRequiredActiveComponent();
        return this.getInstantiatedComponents(pcmModel).anyMatch(this.isInstantiated(requiredActiveComponent));
    }

    private Predicate<AssemblyContext> isInstantiated(InterfaceProvidingRequiringEntity requiredActiveComponent) {
        return assContext -> assContext.getEncapsulatedComponent__AssemblyContext().getId().equals(requiredActiveComponent.getId());
    }

    private Stream<AssemblyContext> getInstantiatedComponents(PCMInstance pcmModel) {
        return pcmModel.getSystem().getAssemblyContexts__ComposedStructure().stream();
    }
}

