/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.precondition;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalPrecondition;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ActiveComponentChecker;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ArchitecturalPreconditionChecker;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.UncertaintyModelEqualityChecker;

public class ArchitecturalPreconditionManager {
    private static final Set<ArchitecturalPreconditionChecker> PRECONDITION_CHECKER = Sets.newHashSet();
    private static ArchitecturalPreconditionManager managerInstance;

    static {
        PRECONDITION_CHECKER.add(new ActiveComponentChecker());
        PRECONDITION_CHECKER.add(new UncertaintyModelEqualityChecker());
        managerInstance = null;
    }

    private ArchitecturalPreconditionManager() {
    }

    public static ArchitecturalPreconditionManager get() {
        if (managerInstance == null) {
            managerInstance = new ArchitecturalPreconditionManager();
        }
        return managerInstance;
    }

    public Optional<ArchitecturalPreconditionChecker> findPreconditionCheckerFor(ArchitecturalPrecondition precondtion) {
        return PRECONDITION_CHECKER.stream().filter(this.preconditionCheckerFor(precondtion)).findFirst();
    }

    private Predicate<ArchitecturalPreconditionChecker> preconditionCheckerFor(ArchitecturalPrecondition precondition) {
        return c -> c.isApplicable(precondition);
    }
}

