/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.precondition;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.dependability.reliability.uncertainty.ArchitecturalPrecondition;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyModelEquality;
import org.palladiosimulator.dependability.reliability.uncertainty.precondition.ArchitecturalPreconditionChecker;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceRelation;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class UncertaintyModelEqualityChecker
implements ArchitecturalPreconditionChecker {
    protected UncertaintyModelEqualityChecker() {
    }

    @Override
    public boolean isApplicable(ArchitecturalPrecondition precondition) {
        return precondition instanceof UncertaintyModelEquality;
    }

    @Override
    public boolean isFulfilled(PCMInstance pcmModel, ArchitecturalPrecondition precondition) {
        if (this.isNotApplicable(precondition)) {
            return false;
        }
        UncertaintyModelEquality equalityPrecondition = (UncertaintyModelEquality)precondition;
        return this.areStructuralEqual(equalityPrecondition.getFirst(), equalityPrecondition.getSecond());
    }

    private boolean areStructuralEqual(GroundProbabilisticNetwork first, GroundProbabilisticNetwork second) {
        EList firstLocalModels = first.getLocalProbabilisticModels();
        EList secondLocalModels = second.getLocalProbabilisticModels();
        if (firstLocalModels.size() != 1 || secondLocalModels.size() != 1) {
            throw new IllegalArgumentException("Models are not following the expected structure, i.e. they encompass more than one local model");
        }
        if (firstLocalModels.size() != secondLocalModels.size()) {
            return false;
        }
        if (this.instantiateDistinctRandomVariables((LocalProbabilisticNetwork)firstLocalModels.get(0), (LocalProbabilisticNetwork)secondLocalModels.get(0))) {
            return false;
        }
        return !this.haveDistinctDependencyStructures((LocalProbabilisticNetwork)firstLocalModels.get(0), (LocalProbabilisticNetwork)secondLocalModels.get(0));
    }

    private boolean instantiateDistinctRandomVariables(LocalProbabilisticNetwork firstNetwork, LocalProbabilisticNetwork secondNetwork) {
        ArrayList copySecondVariables = Lists.newArrayList((Iterable)secondNetwork.getGroundRandomVariables());
        for (GroundRandomVariable each : firstNetwork.getGroundRandomVariables()) {
            copySecondVariables.removeIf(this.instantiateSameTemplate(each));
        }
        return !copySecondVariables.isEmpty();
    }

    private boolean haveDistinctDependencyStructures(LocalProbabilisticNetwork firstNetwork, LocalProbabilisticNetwork secondNetwork) {
        for (GroundRandomVariable each : firstNetwork.getGroundRandomVariables()) {
            GroundRandomVariable counterpart = secondNetwork.getGroundRandomVariables().stream().filter(this.instantiateSameTemplate(each)).findFirst().get();
            if (each.getDependenceStructure().size() != counterpart.getDependenceStructure().size()) {
                return true;
            }
            if (each.getDependenceStructure().size() == 0) continue;
            ArrayList dependencies = Lists.newArrayList((Iterable)counterpart.getDependenceStructure());
            for (DependenceRelation relation : each.getDependenceStructure()) {
                dependencies.removeIf(r -> r.getSource().getId().equals(relation.getSource().getId()));
            }
            if (dependencies.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Predicate<GroundRandomVariable> instantiateSameTemplate(GroundRandomVariable each) {
        return v -> v.getInstantiatedTemplate().getId().equals(each.getInstantiatedTemplate().getId());
    }
}

