/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.reliability.uncertainty.improvement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.palladiosimulator.dependability.reliability.uncertainty.DeterministicImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.MapEntry;
import org.palladiosimulator.dependability.reliability.uncertainty.ProbabilisticImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.UncertaintyImprovement;
import org.palladiosimulator.dependability.reliability.uncertainty.util.UncertaintySwitch;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ConditionalProbabilityDistribution;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.distributionfunction.Domain;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.TabularCPD;

public class UncertaintyImprovementCalculator {
    private static final UncertaintyImprovementCalculator CALCULATOR_INSTANCE = new UncertaintyImprovementCalculator();

    private UncertaintyImprovementCalculator() {
    }

    public static UncertaintyImprovementCalculator get() {
        return CALCULATOR_INSTANCE;
    }

    public CategoricalValue calculate(UncertaintyImprovement improvement, final CategoricalValue value, final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        return (CategoricalValue)new UncertaintySwitch<CategoricalValue>(){

            @Override
            public CategoricalValue caseProbabilisticImprovement(ProbabilisticImprovement object) {
                return UncertaintyImprovementCalculator.this.calculateProbabilistically(object, value, (IProbabilityDistributionFactory<CategoricalValue>)probabilityDistributionFactory);
            }

            @Override
            public CategoricalValue caseDeterministicImprovement(DeterministicImprovement object) {
                return UncertaintyImprovementCalculator.this.calculateDeterministically(object, value);
            }
        }.doSwitch(improvement);
    }

    private CategoricalValue calculateProbabilistically(ProbabilisticImprovement improvement, CategoricalValue value, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        ConditionalProbabilityDistribution distribution = this.createCPD(improvement.getProbabilityDistribution(), probabilityDistributionFactory);
        ArrayList conditionals = Lists.newArrayList((Object[])new Conditionable.Conditional[]{new Conditionable.Conditional(Domain.CATEGORY, (Value)value)});
        return distribution.given((List)conditionals).sample();
    }

    public ConditionalProbabilityDistribution createCPD(ProbabilityDistribution dist, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        if (dist.getParams().isEmpty()) {
            throw new IllegalArgumentException("The distribution parameters must be set.");
        }
        ParamRepresentation paramRepresentation = ((Parameter)dist.getParams().get(0)).getRepresentation();
        if (!TabularCPD.class.isInstance(paramRepresentation)) {
            throw new IllegalArgumentException("The parameter representation must be of type TabularCPD.");
        }
        return new ConditionalProbabilityDistribution(dist, (TabularCPD)paramRepresentation, probabilityDistributionFactory);
    }

    public ConditionalProbabilityDistribution createIndicatorCPD(final DeterministicImprovement improvement, final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory) {
        return new ConditionalProbabilityDistribution(null, null, probabilityDistributionFactory){
            private CategoricalValue givenValue;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.givenValue = null;
            }

            public Double probability(CategoricalValue value) {
                if (this.givenValue == null) {
                    throw new RuntimeException("The conditional value must be set.");
                }
                CategoricalValue deterministicValue = UncertaintyImprovementCalculator.this.calculate(improvement, this.givenValue, (IProbabilityDistributionFactory<CategoricalValue>)probabilityDistributionFactory);
                return ((String)value.get()).equals(deterministicValue.get()) ? 1.0 : 0.0;
            }

            public CategoricalValue sample() {
                if (this.givenValue == null) {
                    throw new RuntimeException("The conditional value must be set.");
                }
                return UncertaintyImprovementCalculator.this.calculate(improvement, this.givenValue, (IProbabilityDistributionFactory<CategoricalValue>)probabilityDistributionFactory);
            }

            public ConditionalProbabilityDistribution given(List<Conditionable.Conditional<CategoricalValue>> conditionals) {
                if (conditionals.size() != 1) {
                    throw new IllegalArgumentException("There must be no more than one conditional.");
                }
                Conditionable.Conditional<CategoricalValue> value = conditionals.get(0);
                if (!CategoricalValue.class.isInstance(value)) {
                    throw new IllegalArgumentException("The conditional must be a categorical value.");
                }
                this.givenValue = (CategoricalValue)value.getValue();
                return this;
            }
        };
    }

    private CategoricalValue calculateDeterministically(DeterministicImprovement improvement, CategoricalValue value) {
        return improvement.getMappingTable().stream().filter(this.entryMatching((String)value.get())).map(this.toCategoricalValue()).findFirst().orElse(value);
    }

    private Function<MapEntry, CategoricalValue> toCategoricalValue() {
        return entry -> CategoricalValue.create((String)entry.getValue());
    }

    private Predicate<MapEntry> entryMatching(String value) {
        return entry -> entry.getKey().equals(value);
    }
}

