/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.jobs;

import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.accuracy.transformation.AbstractAccuracyInfluenceSEFFTransformationStrategy;
import org.palladiosimulator.analyzer.accuracy.transformation.AccuracyInfluenceSEFFTransformationStrategyAsSpecified;
import org.palladiosimulator.analyzer.accuracy.transformation.AccuracyInfluenceSEFFTransformationStrategyMaximum;
import org.palladiosimulator.analyzer.accuracy.transformation.AccuracyInfluenceSEFFTransformationStrategyMinimum;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.core.runconfig.AccuracyInfluenceAnalysisState;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class TransformPCMForAccuracyInfluenceAnalysisJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(TransformPCMForAccuracyInfluenceAnalysisJob.class);
    private AbstractPCMWorkflowRunConfiguration configuration;

    public TransformPCMForAccuracyInfluenceAnalysisJob(AbstractPCMWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (!this.configuration.isAccuracyInfluenceAnalysisEnabled()) {
            throw new IllegalArgumentException("The transformation job on PCM models for the accuracy analysis may only be run if the accuracy influence analysis is enabled.");
        }
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        Allocation allocation = pcmPartition.getAllocation();
        ArrayList allocatedSEFFs = new ArrayList();
        for (AllocationContext allocationContext : allocation.getAllocationContexts_Allocation()) {
            AssemblyContext outmostAssemblyContext = allocationContext.getAssemblyContext_AllocationContext();
            List<ServiceEffectSpecification> assembledSEFFs = this.discoverSEFFs(outmostAssemblyContext);
            TransformPCMForAccuracyInfluenceAnalysisJob.addElementsToList(allocatedSEFFs, assembledSEFFs);
        }
        AbstractAccuracyInfluenceSEFFTransformationStrategy accuracyInfluenceSEFFtransformator = switch (this.configuration.getAccuracyInfluenceAnalysisState()) {
            case AccuracyInfluenceAnalysisState.MINIMUM -> new AccuracyInfluenceSEFFTransformationStrategyMinimum(pcmPartition);
            case AccuracyInfluenceAnalysisState.AS_SPECIFIED -> new AccuracyInfluenceSEFFTransformationStrategyAsSpecified(pcmPartition);
            case AccuracyInfluenceAnalysisState.MAXIMUM -> new AccuracyInfluenceSEFFTransformationStrategyMaximum(pcmPartition);
            default -> {
                String msg = "The handling of the accuracy influence strategy " + this.configuration.getAccuracyInformationModelFile() + " provided in the configuration is not implemented.";
                LOGGER.fatal((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        };
        for (ServiceEffectSpecification seff : allocatedSEFFs) {
            accuracyInfluenceSEFFtransformator.doSwitch((EObject)seff);
        }
        if (this.configuration.getAccuracyInfluenceIssueReceivingJob() == null) {
            LOGGER.warn((Object)"No job was specified to receive issues occured during accuracy influence analysis. There will be no notifications about warnings or errors.");
        } else {
            this.configuration.getAccuracyInfluenceIssueReceivingJob().addIssues(accuracyInfluenceSEFFtransformator.getIssues());
        }
    }

    private List<ServiceEffectSpecification> discoverSEFFs(AssemblyContext assemblyContext) {
        ArrayList<ServiceEffectSpecification> composedSEFFs = new ArrayList<ServiceEffectSpecification>();
        RepositoryComponent repositoryComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
        if (repositoryComponent instanceof ComposedStructure) {
            ComposedStructure composedStructure = (ComposedStructure)repositoryComponent;
            for (AssemblyContext composedComponentsContext : composedStructure.getAssemblyContexts__ComposedStructure()) {
                List<ServiceEffectSpecification> assembledSEFFs = this.discoverSEFFs(composedComponentsContext);
                TransformPCMForAccuracyInfluenceAnalysisJob.addElementsToList(composedSEFFs, assembledSEFFs);
            }
        } else if (repositoryComponent instanceof BasicComponent) {
            BasicComponent basicComponent = (BasicComponent)repositoryComponent;
            TransformPCMForAccuracyInfluenceAnalysisJob.addElementsToList(composedSEFFs, basicComponent.getServiceEffectSpecifications__BasicComponent());
        } else {
            LOGGER.warn((Object)("Could not process the provided repository component " + repositoryComponent.getEntityName() + " with id " + repositoryComponent.getId() + ". The component type is not supported by the implementation."));
        }
        return composedSEFFs;
    }

    public static <T> void addElementsToList(List<T> target, List<T> source) {
        for (T t : source) {
            if (target.contains(t)) continue;
            target.add(t);
        }
    }
}

