/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.issues;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.core.SeverityEnum;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.accuracy.issues.CharacterisedPCMParameterPartitionSourceCodeIssue;
import org.palladiosimulator.analyzer.accuracy.issues.RDSEFFSourceCodeIssue;
import org.palladiosimulator.analyzer.accuracy.issues.VariableSourceCodeIssue;

public class AccuracyIssueFactory {
    public static SeverityAndIssue createMissingQualityAnnotationIssue(EObject object) {
        return new SeverityAndIssue(SeverityEnum.WARNING, "No information on the quality was provided for the RDSEFF. Assuming a quality of ExactlyAsSpecifiedPrecision. This assumption may lead to prediction errors.", object);
    }

    public static SeverityAndIssue createMissingQualityAnnotationIssue(String resourceName, String rdseffId) {
        return new RDSEFFSourceCodeIssue(SeverityEnum.WARNING, "No information on the quality was provided for the RDSEFF. Assuming a quality of ExactlyAsSpecifiedPrecision. This assumption may lead to prediction errors.", null, resourceName, rdseffId);
    }

    public static SeverityAndIssue createInvalidQualityAnnotationIssue(EObject object) {
        return new SeverityAndIssue(SeverityEnum.WARNING, "The quality information provided for the RDSEFF was invalid. Assuming a quality of ExactlyAsSpecifiedPrecision. This assumption may lead to prediction errors.", object);
    }

    public static SeverityAndIssue createParameterExtrapolationIssue(String variableReference, String rdseffId, String resourceName, Object actualValue, String actionId) {
        return new VariableSourceCodeIssue(SeverityEnum.WARNING, "The experienced parameter value was outside of the provided accuracy bounds. The experienced value is used nonetheless. This extrapolation may lead to prediction errors.", actualValue, resourceName, rdseffId, actionId, variableReference);
    }

    public static SeverityAndIssue createTypeInferenceIssue(String msg) {
        return new SeverityAndIssue(SeverityEnum.ERROR, msg, null);
    }

    public static SeverityAndIssue createCharacterisedPCMParameterPartition(String msg, String objectResourceName, String partitionId) {
        return new CharacterisedPCMParameterPartitionSourceCodeIssue(SeverityEnum.ERROR, msg, null, objectResourceName, partitionId);
    }
}

