/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.transformation;

import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.accuracy.transformation.PCMRandomVariableSpecificationAccuracyMinimumTrafo;
import org.palladiosimulator.analyzer.quality.qualityannotation.ExactlyAsSpecifiedPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.LimitedDeviationPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.NoPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.util.QualityAnnotationSwitch;

public class ValidationPrecisionToMaximumLongValue
extends QualityAnnotationSwitch<Long> {
    private static final Logger LOGGER = Logger.getLogger(PCMRandomVariableSpecificationAccuracyMinimumTrafo.class);
    private Long absoluteValue;

    public void setAbsoluteValue(Long absoluteValue) {
        this.absoluteValue = absoluteValue;
    }

    public Long caseNoPrecision(NoPrecision object) {
        this.checkAbsoluteValue();
        this.absoluteValue = null;
        return Long.MAX_VALUE;
    }

    public Long caseExactlyAsSpecifiedPrecision(ExactlyAsSpecifiedPrecision object) {
        this.checkAbsoluteValue();
        long abs = this.absoluteValue;
        this.absoluteValue = null;
        return abs;
    }

    public Long caseLimitedDeviationPrecision(LimitedDeviationPrecision object) {
        this.checkAbsoluteValue();
        long max = Math.max((long)((double)this.absoluteValue.longValue() + Math.ceil(object.getAbsolute())), (long)((double)this.absoluteValue.longValue() + Math.ceil((double)this.absoluteValue.longValue() * object.getRelative())));
        this.absoluteValue = null;
        return max;
    }

    private void checkAbsoluteValue() {
        if (this.absoluteValue == null) {
            String msg = "You have to set the absolute value before invoking doSwitch(). Note: The absolute value is reset after an execution of doSwitch() to prevent accidental re-use.";
            LOGGER.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }
}

