/**
 */
package org.palladiosimulator.analyzer.quality.parameters.pcm.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.analyzer.quality.parameters.pcm.util.PCMAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class PCMItemProviderAdapterFactory extends PCMAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public PCMItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMParameterValue} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMParameterValueItemProvider pcmParameterValueItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMParameterValue}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMParameterValueAdapter() {
        if (this.pcmParameterValueItemProvider == null) {
            this.pcmParameterValueItemProvider = new PCMParameterValueItemProvider(this);
        }

        return this.pcmParameterValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMInfrastructureOperationReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMInfrastructureOperationReferenceItemProvider pcmInfrastructureOperationReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMInfrastructureOperationReference}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMInfrastructureOperationReferenceAdapter() {
        if (this.pcmInfrastructureOperationReferenceItemProvider == null) {
            this.pcmInfrastructureOperationReferenceItemProvider = new PCMInfrastructureOperationReferenceItemProvider(
                    this);
        }

        return this.pcmInfrastructureOperationReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMBusinessOperationReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMBusinessOperationReferenceItemProvider pcmBusinessOperationReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMBusinessOperationReference}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMBusinessOperationReferenceAdapter() {
        if (this.pcmBusinessOperationReferenceItemProvider == null) {
            this.pcmBusinessOperationReferenceItemProvider = new PCMBusinessOperationReferenceItemProvider(this);
        }

        return this.pcmBusinessOperationReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMComponentReferenceItemProvider pcmComponentReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentReference}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMComponentReferenceAdapter() {
        if (this.pcmComponentReferenceItemProvider == null) {
            this.pcmComponentReferenceItemProvider = new PCMComponentReferenceItemProvider(this);
        }

        return this.pcmComponentReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentParameterReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMComponentParameterReferenceItemProvider pcmComponentParameterReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMComponentParameterReference}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMComponentParameterReferenceAdapter() {
        if (this.pcmComponentParameterReferenceItemProvider == null) {
            this.pcmComponentParameterReferenceItemProvider = new PCMComponentParameterReferenceItemProvider(this);
        }

        return this.pcmComponentParameterReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMOperationParameterReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMOperationParameterReferenceItemProvider pcmOperationParameterReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMOperationParameterReference}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMOperationParameterReferenceAdapter() {
        if (this.pcmOperationParameterReferenceItemProvider == null) {
            this.pcmOperationParameterReferenceItemProvider = new PCMOperationParameterReferenceItemProvider(this);
        }

        return this.pcmOperationParameterReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMRequiredBusinessOperationReturnParameterReference}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected PCMRequiredBusinessOperationReturnParameterReferenceItemProvider pcmRequiredBusinessOperationReturnParameterReferenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.analyzer.quality.parameters.pcm.PCMRequiredBusinessOperationReturnParameterReference}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPCMRequiredBusinessOperationReturnParameterReferenceAdapter() {
        if (this.pcmRequiredBusinessOperationReturnParameterReferenceItemProvider == null) {
            this.pcmRequiredBusinessOperationReturnParameterReferenceItemProvider = new PCMRequiredBusinessOperationReturnParameterReferenceItemProvider(
                    this);
        }

        return this.pcmRequiredBusinessOperationReturnParameterReferenceItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.pcmParameterValueItemProvider != null) {
            this.pcmParameterValueItemProvider.dispose();
        }
        if (this.pcmInfrastructureOperationReferenceItemProvider != null) {
            this.pcmInfrastructureOperationReferenceItemProvider.dispose();
        }
        if (this.pcmBusinessOperationReferenceItemProvider != null) {
            this.pcmBusinessOperationReferenceItemProvider.dispose();
        }
        if (this.pcmComponentReferenceItemProvider != null) {
            this.pcmComponentReferenceItemProvider.dispose();
        }
        if (this.pcmComponentParameterReferenceItemProvider != null) {
            this.pcmComponentParameterReferenceItemProvider.dispose();
        }
        if (this.pcmOperationParameterReferenceItemProvider != null) {
            this.pcmOperationParameterReferenceItemProvider.dispose();
        }
        if (this.pcmRequiredBusinessOperationReturnParameterReferenceItemProvider != null) {
            this.pcmRequiredBusinessOperationReturnParameterReferenceItemProvider.dispose();
        }
    }

}
