/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.util;

import java.util.Arrays;
import java.util.List;
import org.palladiosimulator.analyzer.quality.qualityannotation.ServiceSpecification;
import org.palladiosimulator.analyzer.quality.util.Checksum_PCM_10;
import org.palladiosimulator.analyzer.quality.util.SpecificationChecksumCalculator;

public class ValidationUtilities {
    public static List<SpecificationChecksumCalculator> calculators = Arrays.asList(new Checksum_PCM_10());

    public static long calculate(ServiceSpecification specification, String algorithmIdentifier) {
        for (SpecificationChecksumCalculator calculator : calculators) {
            if (!calculator.identify().equals(algorithmIdentifier)) continue;
            return calculator.calculate(specification);
        }
        throw new IllegalArgumentException("There was no algorithm known for the provided identifier. The identifier was " + algorithmIdentifier);
    }

    public static void update(ServiceSpecification specification, String algorithmIdentifier) {
        for (SpecificationChecksumCalculator calculator : calculators) {
            if (!calculator.identify().equals(algorithmIdentifier)) continue;
            calculator.update(specification);
            return;
        }
        throw new IllegalArgumentException("There was no algorithm known for the provided identifier. The identifier was " + algorithmIdentifier);
    }
}

