/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.qualityannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PCMRERequestCategory implements Enumerator
{
    RESOURCE(1, "Resource", "Resource"),
    INFRASTRUCTURE(2, "Infrastructure", "Infrastructure"),
    COMPONENT(3, "Component", "Component"),
    RESOURCE_DEMAND(4, "ResourceDemand", "ResourceDemand"),
    COMPONENT_INTERNAL(5, "ComponentInternal", "ComponentInternal");

    public static final int RESOURCE_VALUE = 1;
    public static final int INFRASTRUCTURE_VALUE = 2;
    public static final int COMPONENT_VALUE = 3;
    public static final int RESOURCE_DEMAND_VALUE = 4;
    public static final int COMPONENT_INTERNAL_VALUE = 5;
    private static final PCMRERequestCategory[] VALUES_ARRAY;
    public static final List<PCMRERequestCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PCMRERequestCategory[]{RESOURCE, INFRASTRUCTURE, COMPONENT, RESOURCE_DEMAND, COMPONENT_INTERNAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PCMRERequestCategory get(String literal) {
        PCMRERequestCategory[] pCMRERequestCategoryArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            PCMRERequestCategory result = pCMRERequestCategoryArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static PCMRERequestCategory getByName(String name) {
        PCMRERequestCategory[] pCMRERequestCategoryArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            PCMRERequestCategory result = pCMRERequestCategoryArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static PCMRERequestCategory get(int value) {
        switch (value) {
            case 1: {
                return RESOURCE;
            }
            case 2: {
                return INFRASTRUCTURE;
            }
            case 3: {
                return COMPONENT;
            }
            case 4: {
                return RESOURCE_DEMAND;
            }
            case 5: {
                return COMPONENT_INTERNAL;
            }
        }
        return null;
    }

    private PCMRERequestCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

