/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.util;

import java.util.zip.Checksum;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.quality.util.Checksum_PCM_10;
import org.palladiosimulator.analyzer.quality.util.PCMUtil;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.InternalCallAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;

public class ActionChecksumSwitch
extends SeffSwitch<Boolean> {
    private Checksum checksum;

    public ActionChecksumSwitch(Checksum checksum) {
        this.checksum = checksum;
    }

    protected void updateChecksumWithOrder(AbstractAction action) {
        Checksum_PCM_10.updateChecksum(this.checksum, "_" + action.eClass().getName());
    }

    protected void updateChecksumWithVariableUsage(VariableUsage variableUsage) {
        Checksum_PCM_10.updateChecksum(this.checksum, "(" + PCMUtil.getQualifiedName(variableUsage));
        for (VariableCharacterisation varChar : variableUsage.getVariableCharacterisation_VariableUsage()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + varChar.getType().getLiteral() + "=" + this.toUnformattedSpecification(varChar.getSpecification_VariableCharacterisation()));
        }
        Checksum_PCM_10.updateChecksum(this.checksum, ")");
    }

    protected void updateChecksumWithAICFACalls(AbstractInternalControlFlowAction action) {
        for (InfrastructureCall infrastructureCall : action.getInfrastructureCall__Action()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + infrastructureCall.getSignature__InfrastructureCall().getId());
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + infrastructureCall.getRequiredRole__InfrastructureCall().getId());
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + this.toUnformattedSpecification(infrastructureCall.getNumberOfCalls__InfrastructureCall()));
            for (VariableUsage variableUsage : infrastructureCall.getInputVariableUsages__CallAction()) {
                this.updateChecksumWithVariableUsage(variableUsage);
            }
        }
        for (ResourceCall resourceCall : action.getResourceCall__Action()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + resourceCall.getSignature__ResourceCall().getId());
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + resourceCall.getResourceRequiredRole__ResourceCall().getId());
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + this.toUnformattedSpecification(resourceCall.getNumberOfCalls__ResourceCall()));
            for (VariableUsage variableUsage : resourceCall.getInputVariableUsages__CallAction()) {
                this.updateChecksumWithVariableUsage(variableUsage);
            }
        }
        for (ParametricResourceDemand demand : action.getResourceDemand_Action()) {
            Checksum_PCM_10.updateChecksum(this.checksum, String.valueOf(demand.eClass().getName()) + "_" + demand.getRequiredResource_ParametricResourceDemand().getId() + "_" + demand.getRequiredResource_ParametricResourceDemand().getEntityName() + ")" + this.toUnformattedSpecification(demand.getSpecification_ParametericResourceDemand()));
        }
    }

    protected String toUnformattedSpecification(PCMRandomVariable specification) {
        return specification.getSpecification().replaceAll("[\t\n\f\r\u000b]", "");
    }

    public Boolean caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        Checksum_PCM_10.updateChecksum(this.checksum, "(");
        StartAction action = PCMUtil.getInitialAction(object);
        while (action != null) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + action.eClass().getName());
            this.doSwitch((EObject)action);
            action = action.getSuccessor_AbstractAction();
        }
        Checksum_PCM_10.updateChecksum(this.checksum, ")");
        return true;
    }

    public Boolean caseStartAction(StartAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        return true;
    }

    public Boolean caseStopAction(StopAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        return true;
    }

    public Boolean caseInternalAction(InternalAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        return true;
    }

    public Boolean caseInternalCallAction(InternalCallAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        this.doSwitch((EObject)object.getCalledResourceDemandingInternalBehaviour());
        return true;
    }

    public Boolean caseExternalCallAction(ExternalCallAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        Checksum_PCM_10.updateChecksum(this.checksum, "_" + object.getCalledService_ExternalService().getId() + "_" + object.getRole_ExternalService() + "(" + "Input=");
        for (VariableUsage variableUsage : object.getInputVariableUsages__CallAction()) {
            this.updateChecksumWithVariableUsage(variableUsage);
        }
        Checksum_PCM_10.updateChecksum(this.checksum, "_Output=");
        for (VariableUsage variableUsage : object.getReturnVariableUsage__CallReturnAction()) {
            this.updateChecksumWithVariableUsage(variableUsage);
        }
        Checksum_PCM_10.updateChecksum(this.checksum, ")");
        return true;
    }

    public Boolean caseSetVariableAction(SetVariableAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        for (VariableUsage variableUsage : object.getLocalVariableUsages_SetVariableAction()) {
            this.updateChecksumWithVariableUsage(variableUsage);
        }
        return true;
    }

    public Boolean caseAcquireAction(AcquireAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        Checksum_PCM_10.updateChecksum(this.checksum, object.getPassiveresource_AcquireAction().getId());
        return true;
    }

    public Boolean caseReleaseAction(ReleaseAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        Checksum_PCM_10.updateChecksum(this.checksum, object.getPassiveResource_ReleaseAction().getId());
        return true;
    }

    public Boolean caseLoopAction(LoopAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        Checksum_PCM_10.updateChecksum(this.checksum, "_" + this.toUnformattedSpecification(object.getIterationCount_LoopAction()));
        this.doSwitch((EObject)object.getBodyBehaviour_Loop());
        return true;
    }

    public Boolean caseCollectionIteratorAction(CollectionIteratorAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        Checksum_PCM_10.updateChecksum(this.checksum, "_" + object.getParameter_CollectionIteratorAction().getParameterName());
        this.doSwitch((EObject)object.getBodyBehaviour_Loop());
        return true;
    }

    public Boolean caseBranchAction(BranchAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        int i = 0;
        for (AbstractBranchTransition abt : object.getBranches_Branch()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + Integer.toString(i++) + "_" + abt.eClass().getName());
            if (abt instanceof GuardedBranchTransition) {
                GuardedBranchTransition gbt = (GuardedBranchTransition)abt;
                Checksum_PCM_10.updateChecksum(this.checksum, "_" + this.toUnformattedSpecification(gbt.getBranchCondition_GuardedBranchTransition()));
            } else if (abt instanceof ProbabilisticBranchTransition) {
                ProbabilisticBranchTransition pbt = (ProbabilisticBranchTransition)abt;
                Checksum_PCM_10.updateChecksum(this.checksum, "_" + Double.toString(pbt.getBranchProbability()));
            } else {
                throw new IllegalArgumentException("Branch transition must be guarded or probabilistic. Exprienced type: " + abt.eClass().getName());
            }
            this.doSwitch((EObject)abt.getBranchBehaviour_BranchTransition());
        }
        return true;
    }

    public Boolean caseForkAction(ForkAction object) {
        this.updateChecksumWithOrder((AbstractAction)object);
        this.updateChecksumWithAICFACalls((AbstractInternalControlFlowAction)object);
        int i = 0;
        for (ForkedBehaviour behavior : object.getAsynchronousForkedBehaviours_ForkAction()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + Integer.toString(i++) + "_" + "Asynchronous");
            this.doSwitch((EObject)behavior);
        }
        i = 0;
        for (ForkedBehaviour behavior : object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint()) {
            Checksum_PCM_10.updateChecksum(this.checksum, "_" + Integer.toString(i++) + "_" + "Synchronized");
            this.doSwitch((EObject)behavior);
        }
        for (VariableUsage variableUsage : object.getSynchronisingBehaviours_ForkAction().getOutputParameterUsage_SynchronisationPoint()) {
            this.updateChecksumWithVariableUsage(variableUsage);
        }
        return true;
    }
}

