/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.util;

import java.util.logging.Logger;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMPE;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMPEAllDecisions;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMPEDecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRE;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRECategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMREInterface;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRERequestCategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMREResourceInterface;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMREResourceSignature;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRERole;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRESignature;
import org.palladiosimulator.analyzer.quality.qualityannotation.Precision;
import org.palladiosimulator.analyzer.quality.qualityannotation.ProbabilisticElement;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotation;
import org.palladiosimulator.analyzer.quality.qualityannotation.REPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.RequiredElement;
import org.palladiosimulator.analyzer.quality.util.EMFHelper;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;
import org.palladiosimulator.pcm.resourcetype.ResourceSignature;
import org.palladiosimulator.pcm.seff.BranchAction;

public class QualityAnnotationLookup {
    public static final Logger LOGGER = Logger.getLogger(QualityAnnotationLookup.class.getCanonicalName());
    private QualityAnnotation qualityAnnotation;

    public QualityAnnotationLookup(QualityAnnotation qualityAnnotation) {
        this.qualityAnnotation = qualityAnnotation;
    }

    public PCMPE getPCMPE(BranchAction branchAction) {
        for (ProbabilisticElement pe : this.qualityAnnotation.getProbabilisticElements()) {
            if (!(pe instanceof PCMPEAllDecisions)) continue;
            PCMPEAllDecisions allDecisions = (PCMPEAllDecisions)pe;
            for (ProbabilisticElement peLevel2 : allDecisions.getChildPEs()) {
                PCMPEDecision decision;
                if (!(peLevel2 instanceof PCMPEDecision) || !(decision = (PCMPEDecision)peLevel2).getBranchAction().equals(branchAction)) continue;
                return decision;
            }
            return allDecisions;
        }
        return null;
    }

    public Precision getPCMPEPrecision(BranchAction branchAction) {
        PCMPE pcmpe = this.getPCMPE(branchAction);
        if (pcmpe == null) {
            return null;
        }
        return pcmpe.getPrecision();
    }

    public PCMRECategory getRequiredElement(PCMRERequestCategory category) {
        int found = 0;
        PCMRECategory result = null;
        for (RequiredElement re : this.qualityAnnotation.getStipulatedREPrecisions()) {
            PCMRECategory foundRE;
            if (!(re instanceof PCMRECategory) || !(foundRE = (PCMRECategory)re).getCategory().equals((Object)category)) continue;
            result = foundRE;
            ++found;
        }
        if (found > 1) {
            throw new IllegalStateException("Cardinality of [0..1] breached. " + found + " request elements satisfied the search condition. ");
        }
        return result;
    }

    public PCMREInterface getRequiredElement(Interface iface) {
        int found = 0;
        PCMREInterface result = null;
        for (RequiredElement re : this.qualityAnnotation.getStipulatedREPrecisions()) {
            PCMREInterface foundRE;
            if (!(re instanceof PCMREInterface) || (foundRE = (PCMREInterface)re).getInterface() != iface) continue;
            result = foundRE;
            ++found;
        }
        if (found > 1) {
            throw new IllegalStateException("Cardinality of [0..1] breached. " + found + " request elements satisfied the search condition. ");
        }
        return result;
    }

    public PCMRERole getRequiredElement(Role role) {
        int found = 0;
        PCMRERole result = null;
        for (RequiredElement re : this.qualityAnnotation.getStipulatedREPrecisions()) {
            PCMRERole foundRE;
            if (!(re instanceof PCMRERole) || (foundRE = (PCMRERole)re).getRole() != role) continue;
            result = foundRE;
            ++found;
        }
        if (found > 1) {
            throw new IllegalStateException("Cardinality of [0..1] breached. " + found + " request elements satisfied the search condition. ");
        }
        return result;
    }

    public PCMRESignature getRequiredElement(Signature signature) {
        int found = 0;
        PCMRESignature result = null;
        for (RequiredElement re : this.qualityAnnotation.getStipulatedREPrecisions()) {
            PCMRESignature foundRE;
            if (!(re instanceof PCMRESignature) || (foundRE = (PCMRESignature)re).getSignature() != signature) continue;
            result = foundRE;
            ++found;
        }
        if (found > 1) {
            throw new IllegalStateException("Cardinality of [0..1] breached. " + found + " request elements satisfied the search condition. ");
        }
        return result;
    }

    public Precision getPCMREPrecisionNoC(InfrastructureSignature signature, InfrastructureRequiredRole role) {
        REPrecision precision = this.getPCMREPrecision(signature, role);
        return precision == null ? null : precision.getDefaultPrecisionNumberOfCalls();
    }

    public Precision getPCMREPrecisionCP(InfrastructureSignature signature, InfrastructureRequiredRole role) {
        REPrecision precision = this.getPCMREPrecision(signature, role);
        return precision == null ? null : precision.getDefaultPrecisionCallParameter();
    }

    public Precision getPCMREPrecisionNoC(OperationSignature signature, OperationRequiredRole role) {
        REPrecision precision = this.getPCMREPrecision(signature, role);
        return precision == null ? null : precision.getDefaultPrecisionNumberOfCalls();
    }

    public Precision getPCMREPrecisionCP(OperationSignature signature, OperationRequiredRole role) {
        REPrecision precision = this.getPCMREPrecision(signature, role);
        return precision == null ? null : precision.getDefaultPrecisionCallParameter();
    }

    public REPrecision getPCMREPrecision(OperationSignature signature, OperationRequiredRole role) {
        PCMRERequestCategory category = PCMRERequestCategory.COMPONENT;
        OperationInterface iface = signature.getInterface__OperationSignature();
        PCMRE current = this.getPCMRE((Signature)signature, (Role)role, category, (Interface)iface);
        return current == null ? null : current.getPrecision();
    }

    public REPrecision getPCMREPrecision(InfrastructureSignature signature, InfrastructureRequiredRole role) {
        PCMRERequestCategory category = PCMRERequestCategory.INFRASTRUCTURE;
        InfrastructureInterface iface = signature == null ? null : signature.getInfrastructureInterface__InfrastructureSignature();
        PCMRE current = this.getPCMRE((Signature)signature, (Role)role, category, (Interface)iface);
        return current == null ? null : current.getPrecision();
    }

    public REPrecision getPCMREPrecision(ResourceSignature signature, ResourceRequiredRole role) {
        PCMRERequestCategory category = PCMRERequestCategory.RESOURCE;
        ResourceInterface iface = signature == null ? null : signature.getResourceInterface__ResourceSignature();
        PCMRE current = this.getPCMRE(signature, (Role)role, category, iface);
        return current == null ? null : current.getPrecision();
    }

    public REPrecision getPCMREPrecisionCategoryResourceDemand() {
        PCMRERequestCategory category = PCMRERequestCategory.RESOURCE_DEMAND;
        PCMRECategory current = this.getRequiredElement(category);
        return current == null ? null : current.getPrecision();
    }

    public REPrecision getPCMREPrecisionCategoryComponentInternal() {
        PCMRERequestCategory category = PCMRERequestCategory.COMPONENT_INTERNAL;
        PCMRECategory current = this.getRequiredElement(category);
        return current == null ? null : current.getPrecision();
    }

    private PCMRE getPCMRE(Signature signature, Role role, PCMRERequestCategory category, Interface iface) {
        assert (category == PCMRERequestCategory.INFRASTRUCTURE || category == PCMRERequestCategory.COMPONENT);
        PCMRE current = null;
        PCMRECategory reCategory = null;
        reCategory = this.getRequiredElement(category);
        if (reCategory != null) {
            current = reCategory;
            PCMREInterface reInterface = null;
            for (RequiredElement requiredElement : EMFHelper.getObjectsByType(reCategory.getChildREs(), PCMREInterface.class)) {
                reInterface = (PCMREInterface)requiredElement;
                if (reInterface.getInterface() != iface) continue;
                current = reInterface;
                PCMRERole reRole = null;
                for (RequiredElement req2 : reInterface.getChildREs()) {
                    reRole = (PCMRERole)req2;
                    if (reRole.getRole() != role) continue;
                    current = reRole;
                    PCMRESignature reSignature = null;
                    for (RequiredElement req3 : EMFHelper.getObjectsByType(reRole.getChildREs(), PCMRESignature.class)) {
                        reSignature = (PCMRESignature)req3;
                        if (reSignature.getSignature() != signature) continue;
                        current = reSignature;
                    }
                }
            }
        } else {
            String msg = "Could not find a RE Precision for the category " + (Object)((Object)category) + ". Add an RE Precision for this category.";
            LOGGER.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        return current;
    }

    private PCMRE getPCMRE(ResourceSignature signature, Role role, PCMRERequestCategory category, ResourceInterface iface) {
        assert (category == PCMRERequestCategory.RESOURCE);
        PCMRE current = null;
        PCMRECategory reCategory = null;
        reCategory = this.getRequiredElement(category);
        if (reCategory != null) {
            current = reCategory;
            PCMREResourceInterface reInterface = null;
            for (RequiredElement requiredElement : EMFHelper.getObjectsByType(reCategory.getChildREs(), PCMREResourceInterface.class)) {
                if (!(requiredElement instanceof PCMREResourceInterface) || (reInterface = (PCMREResourceInterface)requiredElement).getResourceInterface() != iface) continue;
                current = reInterface;
                PCMRERole reRole = null;
                for (RequiredElement req2 : reInterface.getChildREs()) {
                    reRole = (PCMRERole)req2;
                    if (reRole.getRole() != role) continue;
                    current = reRole;
                    PCMREResourceSignature reSignature = null;
                    for (RequiredElement req3 : EMFHelper.getObjectsByType(reRole.getChildREs(), PCMREResourceSignature.class)) {
                        reSignature = (PCMREResourceSignature)req3;
                        if (reSignature.getResourceSignature() != signature) continue;
                        current = reSignature;
                    }
                }
            }
        } else {
            String msg = "Could not find a RE Precision for the category " + (Object)((Object)category) + ". Add an RE Precision for this category.";
            LOGGER.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        return current;
    }

    public QualityAnnotation getQualityAnnotation() {
        return this.qualityAnnotation;
    }
}

