/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.core.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateBlackboardPartitionJob
extends AbstractBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(CreateBlackboardPartitionJob.class);
    private final String blackboardId;
    private final Supplier<ResourceSetPartition> partitionSupplier;

    public CreateBlackboardPartitionJob(String blackboardId) {
        this(blackboardId, ResourceSetPartition::new);
    }

    public CreateBlackboardPartitionJob(String blackboardId, Supplier<ResourceSetPartition> partitionSupplier) {
        this.blackboardId = blackboardId;
        this.partitionSupplier = partitionSupplier;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition partition = this.partitionSupplier.get();
        if (((MDSDBlackboard)this.myBlackboard).hasPartition(this.blackboardId)) {
            LOGGER.warn((Object)("The blackboard already contained a partition with id:" + this.blackboardId));
        }
        ((MDSDBlackboard)this.myBlackboard).addPartition(this.blackboardId, (Object)partition);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return "Create Blackboard Partition \"" + this.blackboardId + "\"";
    }
}

