/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AbstractConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String PLUGIN_ID = "org.palladiosimulator.analyzer.workflow";
    public static final String CONFIGURATION_TAB_IMAGE_PATH = "icons/configuration_tab.gif";
    protected Text temporaryLocationField;
    private Label temporaryLocationLabel;
    protected Button defaultLocationButton;
    protected ModifyListener modifyListener;
    protected SelectionListener selectionListener;

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)CONFIGURATION_TAB_IMAGE_PATH);
    }

    public void createControl(Composite parent) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractConfigurationTab.this.setDirty(true);
                AbstractConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractConfigurationTab.this.setDirty(true);
                AbstractConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        ScrolledComposite container = new ScrolledComposite(parent, 768);
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        Composite contentContainer = new Composite((Composite)container, 0);
        container.setContent((Control)contentContainer);
        GridLayout layout = new GridLayout();
        contentContainer.setLayout((Layout)layout);
        this.setControl((Control)container);
        this.createTemporaryDataLocationSection(contentContainer);
        this.createDeleteTemporaryDataAfterAnalysisSection(contentContainer);
        this.createAccuracySection(contentContainer);
        this.createFurtherSections(contentContainer);
        this.setTemporaryLocationElementsEnabled(false);
        container.setMinSize(contentContainer.computeSize(-1, -1));
    }

    protected void createAccuracySection(Composite container) {
    }

    protected void createDeleteTemporaryDataAfterAnalysisSection(Composite container) {
    }

    protected void createTemporaryDataLocationSection(Composite container) {
        Group outputPathGroup = new Group(container, 0);
        outputPathGroup.setText("Location of temporary data");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        outputPathGroup.setLayout((Layout)gridLayout);
        GridData gd_outputPathGroup = new GridData(4, 0x1000000, true, false);
        outputPathGroup.setLayoutData((Object)gd_outputPathGroup);
        this.defaultLocationButton = new Button((Composite)outputPathGroup, 32);
        GridData gridData_dl = new GridData(16384, 0x1000000, false, false, 4, 1);
        this.defaultLocationButton.setLayoutData((Object)gridData_dl);
        this.defaultLocationButton.setText("Use default location");
        this.defaultLocationButton.setSelection(true);
        this.defaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractConfigurationTab.this.setTemporaryLocationElementsEnabled(!AbstractConfigurationTab.this.defaultLocationButton.getSelection());
                if (AbstractConfigurationTab.this.defaultLocationButton.getSelection()) {
                    AbstractConfigurationTab.this.temporaryLocationField.setText("org.palladiosimulator.temporary");
                }
                AbstractConfigurationTab.this.setDirty(true);
                AbstractConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.temporaryLocationLabel = new Label((Composite)outputPathGroup, 0);
        this.temporaryLocationLabel.setLayoutData((Object)new GridData(48, -1));
        this.temporaryLocationLabel.setText("Location:");
        this.temporaryLocationField = new Text((Composite)outputPathGroup, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 20;
        this.temporaryLocationField.setLayoutData((Object)gridData);
        this.temporaryLocationField.setText("org.palladiosimulator.temporary");
        this.temporaryLocationField.addModifyListener(this.modifyListener);
    }

    protected void createFurtherSections(Composite container) {
    }

    private void setTemporaryLocationElementsEnabled(boolean enable) {
        this.temporaryLocationLabel.setEnabled(enable);
        this.temporaryLocationField.setEnabled(enable);
    }

    public String getName() {
        return "Analysis Configuration";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.temporaryLocationField.setText(configuration.getAttribute("outpath", "org.palladiosimulator.temporary"));
            if (this.temporaryLocationField.getText().equals("org.palladiosimulator.temporary")) {
                this.defaultLocationButton.setSelection(true);
                this.setTemporaryLocationElementsEnabled(false);
            } else {
                this.defaultLocationButton.setSelection(false);
                this.setTemporaryLocationElementsEnabled(true);
            }
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Temporary Location Settings", (String)e.getMessage());
            this.defaultLocationButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("outpath", this.temporaryLocationField.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("outpath", "org.palladiosimulator.temporary");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.temporaryLocationField.getText().equals("")) {
            this.setErrorMessage("The location for temporary data is missing.");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

