/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMServiceSpecification;
import org.palladiosimulator.analyzer.quality.qualityannotation.ServiceSpecification;
import org.palladiosimulator.analyzer.quality.util.ActionChecksumSwitch;
import org.palladiosimulator.analyzer.quality.util.PCMUtil;
import org.palladiosimulator.analyzer.quality.util.SpecificationChecksumCalculator;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.util.RepositorySwitch;
import org.palladiosimulator.pcm.resourcetype.ResourceSignature;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;

public class Checksum_PCM_10
implements SpecificationChecksumCalculator {
    public static final Logger LOGGER = Logger.getLogger(Checksum_PCM_10.class.getCanonicalName());
    public static final String CHECKSUM_PCM_10_IDENTIFIER = "PCM 1.0";
    protected static final String SEPARATOR = "_";
    protected static final String SEPARATOR_HIERARCHY_START = "(";
    protected static final String SEPARATOR_HIERARCHY_END = ")";
    private final DataTypeConverter dataTypeConverter = new DataTypeConverter();

    @Override
    public void update(ServiceSpecification specification) {
        Long checksum = this.calculate(specification);
        specification.setChecksum(checksum);
        specification.setChecksumAlg(CHECKSUM_PCM_10_IDENTIFIER);
    }

    @Override
    public long calculate(ServiceSpecification specification) {
        if (!(specification instanceof PCMServiceSpecification)) {
            throw new IllegalArgumentException("This algorithm can only calculate checksums for PCM service specifications. The provided specification type must be PCMServiceSpecification.");
        }
        CRC32 checksum = new CRC32();
        checksum.reset();
        ResourceDemandingSEFF rdseff = ((PCMServiceSpecification)specification).getResourceDemandingSEFF();
        this.updateChecksumWithSignature((Checksum)checksum, rdseff.getDescribedService__SEFF());
        for (VariableUsage usage : rdseff.getBasicComponent_ServiceEffectSpecification().getComponentParameterUsage_ImplementationComponentType()) {
            Checksum_PCM_10.updateChecksum(checksum, "ComponentParameter" + PCMUtil.getQualifiedName(usage));
        }
        for (PassiveResource passiveResource : rdseff.getBasicComponent_ServiceEffectSpecification().getPassiveResource_BasicComponent()) {
            Checksum_PCM_10.updateChecksum(checksum, String.valueOf(passiveResource.eClass().getName()) + SEPARATOR + passiveResource.getId() + SEPARATOR + passiveResource.getEntityName());
        }
        for (RequiredRole requiredRole : rdseff.getBasicComponent_ServiceEffectSpecification().getRequiredRoles_InterfaceRequiringEntity()) {
            Checksum_PCM_10.updateChecksum(checksum, String.valueOf(requiredRole.eClass().getName()) + SEPARATOR + requiredRole.getId());
            if (requiredRole instanceof OperationRequiredRole) {
                OperationRequiredRole operationRequiredRole = (OperationRequiredRole)requiredRole;
                Checksum_PCM_10.updateChecksum(checksum, SEPARATOR + operationRequiredRole.getRequiredInterface__OperationRequiredRole().getId() + SEPARATOR_HIERARCHY_START);
                for (Signature signature : operationRequiredRole.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface()) {
                    this.updateChecksumWithSignature((Checksum)checksum, signature);
                }
                Checksum_PCM_10.updateChecksum(checksum, SEPARATOR_HIERARCHY_END);
                continue;
            }
            if (requiredRole instanceof InfrastructureRequiredRole) {
                InfrastructureRequiredRole infrastructureRequiredRole = (InfrastructureRequiredRole)requiredRole;
                Checksum_PCM_10.updateChecksum(checksum, SEPARATOR + infrastructureRequiredRole.getRequiredInterface__InfrastructureRequiredRole().getId() + SEPARATOR_HIERARCHY_START);
                for (Signature signature : infrastructureRequiredRole.getRequiredInterface__InfrastructureRequiredRole().getInfrastructureSignatures__InfrastructureInterface()) {
                    this.updateChecksumWithSignature((Checksum)checksum, signature);
                }
                Checksum_PCM_10.updateChecksum(checksum, SEPARATOR_HIERARCHY_END);
                continue;
            }
            throw new IllegalArgumentException("Required roles of the component containing the specification may only have operation and infrastructure required roles. Experienced role was:" + requiredRole.eClass().getName());
        }
        for (ResourceRequiredRole rrRole : rdseff.getBasicComponent_ServiceEffectSpecification().getResourceRequiredRoles__ResourceInterfaceRequiringEntity()) {
            Checksum_PCM_10.updateChecksum(checksum, SEPARATOR + rrRole.getId() + SEPARATOR_HIERARCHY_START);
            for (ResourceSignature resourceSignature : rrRole.getRequiredResourceInterface__ResourceRequiredRole().getResourceSignatures__ResourceInterface()) {
                this.updateChecksumWithSignature((Checksum)checksum, resourceSignature);
            }
            Checksum_PCM_10.updateChecksum(checksum, SEPARATOR_HIERARCHY_END);
        }
        ActionChecksumSwitch checksumSwitch = new ActionChecksumSwitch(checksum);
        checksumSwitch.doSwitch((EObject)rdseff);
        return checksum.getValue();
    }

    protected void updateChecksumWithSignature(Checksum checksum, Signature signature) {
        if (signature instanceof OperationSignature) {
            OperationSignature operationSignature = (OperationSignature)signature;
            for (Parameter parameter : operationSignature.getParameters__OperationSignature()) {
                Checksum_PCM_10.updateChecksum(checksum, String.valueOf(parameter.getParameterName()) + SEPARATOR + this.dataTypeConverter.getUniqueIdentifier(parameter.getDataType__Parameter()));
            }
            if (operationSignature.getReturnType__OperationSignature() != null) {
                Checksum_PCM_10.updateChecksum(checksum, this.dataTypeConverter.getUniqueIdentifier(operationSignature.getReturnType__OperationSignature()));
            }
        } else if (signature instanceof InfrastructureSignature) {
            for (Parameter parameter : ((InfrastructureSignature)signature).getParameters__InfrastructureSignature()) {
                Checksum_PCM_10.updateChecksum(checksum, String.valueOf(parameter.getParameterName()) + SEPARATOR + this.dataTypeConverter.getUniqueIdentifier(parameter.getDataType__Parameter()));
            }
        } else {
            throw new IllegalArgumentException("Only signature of operation and infrastructure interfaces can be processed. Provided type was: " + signature.eClass().getName());
        }
    }

    protected void updateChecksumWithSignature(Checksum checksum, ResourceSignature signature) {
        Checksum_PCM_10.updateChecksum(checksum, String.valueOf(Integer.toString(signature.getResourceServiceId())) + SEPARATOR);
        if (signature.getParameter__ResourceSignature() != null) {
            for (Parameter parameter : signature.getParameter__ResourceSignature()) {
                Checksum_PCM_10.updateChecksum(checksum, String.valueOf(parameter.getParameterName()) + SEPARATOR + this.dataTypeConverter.getUniqueIdentifier(parameter.getDataType__Parameter()));
            }
        }
    }

    @Override
    public String identify() {
        return CHECKSUM_PCM_10_IDENTIFIER;
    }

    public static void updateChecksum(Checksum checksum, String string) {
        byte[] byteArray = string.getBytes();
        checksum.update(byteArray, 0, byteArray.length);
    }

    private class DataTypeConverter
    extends RepositorySwitch<String> {
        protected ArrayList<DataType> handledDataTypes;

        private DataTypeConverter() {
        }

        public String getUniqueIdentifier(DataType dataType) {
            this.handledDataTypes = new ArrayList();
            return (String)this.doSwitch((EObject)dataType);
        }

        public String caseCollectionDataType(CollectionDataType object) {
            if (this.handledDataTypes.contains(object)) {
                return String.valueOf(object.eClass().getName()) + Checksum_PCM_10.SEPARATOR + object.getId() + Checksum_PCM_10.SEPARATOR + object.getEntityName();
            }
            this.handledDataTypes.add((DataType)object);
            String result = String.valueOf(object.eClass().getName()) + Checksum_PCM_10.SEPARATOR + object.getId() + Checksum_PCM_10.SEPARATOR + object.getEntityName() + Checksum_PCM_10.SEPARATOR_HIERARCHY_START + (String)this.doSwitch((EObject)object.getInnerType_CollectionDataType()) + Checksum_PCM_10.SEPARATOR_HIERARCHY_END;
            this.handledDataTypes.remove(object);
            return result;
        }

        public String caseCompositeDataType(CompositeDataType object) {
            if (this.handledDataTypes.contains(object)) {
                return String.valueOf(object.eClass().getName()) + Checksum_PCM_10.SEPARATOR + object.getId() + Checksum_PCM_10.SEPARATOR + object.getEntityName();
            }
            this.handledDataTypes.add((DataType)object);
            StringWriter result = new StringWriter();
            result.append(String.valueOf(object.eClass().getName()) + Checksum_PCM_10.SEPARATOR + object.getId() + Checksum_PCM_10.SEPARATOR + object.getEntityName());
            for (InnerDeclaration declaration : object.getInnerDeclaration_CompositeDataType()) {
                result.append(Checksum_PCM_10.SEPARATOR + declaration.getEntityName() + Checksum_PCM_10.SEPARATOR_HIERARCHY_START + (String)this.doSwitch((EObject)declaration.getDatatype_InnerDeclaration()) + Checksum_PCM_10.SEPARATOR_HIERARCHY_END);
            }
            this.handledDataTypes.remove(object);
            return result.toString();
        }

        public String casePrimitiveDataType(PrimitiveDataType object) {
            this.handledDataTypes.add((DataType)object);
            String result = String.valueOf(object.eClass().getName()) + Checksum_PCM_10.SEPARATOR + object.getType().getValue() + Checksum_PCM_10.SEPARATOR + object.getType().getLiteral();
            this.handledDataTypes.remove(object);
            return result;
        }

        public String caseDataType(DataType object) {
            throw new IllegalArgumentException("The provided data type is not supported by this implementation. The data type was " + object.eClass().getName());
        }
    }
}

