/**
 * Copyright SDQ, IPD, U Karlsruhe, 2007
 */
package org.palladiosimulator.analyzer.completions.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.palladiosimulator.analyzer.completions.CompletionsPackage;
import org.palladiosimulator.analyzer.completions.NetworkComponentAllocationContext;

import org.palladiosimulator.pcm.allocation.impl.AllocationContextImpl;

import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Network Component Allocation Context</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.analyzer.completions.impl.NetworkComponentAllocationContextImpl#getLinkingResource <em>Linking Resource</em>}</li>
 * </ul>
 *
 * @generated
 */
public class NetworkComponentAllocationContextImpl extends AllocationContextImpl implements NetworkComponentAllocationContext
{
	/**
	 * The cached value of the '{@link #getLinkingResource() <em>Linking Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinkingResource()
	 * @generated
	 * @ordered
	 */
	protected LinkingResource linkingResource;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkComponentAllocationContextImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return CompletionsPackage.Literals.NETWORK_COMPONENT_ALLOCATION_CONTEXT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LinkingResource getLinkingResource()
	{
		if (linkingResource != null && linkingResource.eIsProxy())
		{
			InternalEObject oldLinkingResource = (InternalEObject)linkingResource;
			linkingResource = (LinkingResource)eResolveProxy(oldLinkingResource);
			if (linkingResource != oldLinkingResource)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE, oldLinkingResource, linkingResource));
			}
		}
		return linkingResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LinkingResource basicGetLinkingResource()
	{
		return linkingResource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLinkingResource(LinkingResource newLinkingResource)
	{
		LinkingResource oldLinkingResource = linkingResource;
		linkingResource = newLinkingResource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE, oldLinkingResource, linkingResource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE:
				if (resolve) return getLinkingResource();
				return basicGetLinkingResource();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE:
				setLinkingResource((LinkingResource)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE:
				setLinkingResource((LinkingResource)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case CompletionsPackage.NETWORK_COMPONENT_ALLOCATION_CONTEXT__LINKING_RESOURCE:
				return linkingResource != null;
		}
		return super.eIsSet(featureID);
	}

} //NetworkComponentAllocationContextImpl
