/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.api.http.StrategyBuilder;
import org.palladiosimulator.protocom.framework.java.ee.api.sockets.CalibrationSocket;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationTable;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ICalibrationListener;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;

class StrategyCalibrator
implements Runnable,
ICalibrationListener {
    private ServletContext context;
    private IStorage storage;
    private ArrayList<String> strategyNames;
    private int totalProgress = 0;

    private void calibrateStrategy(IDemandStrategy strategy, String filename) {
        strategy.setCalibrationListener((ICalibrationListener)this);
        CalibrationTable table = strategy.calibrate();
        if (!strategy.debugEnabled()) {
            try {
                this.storage.createFolder("calibration");
                this.storage.writeFile("calibration/" + filename, table.toBinary());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public StrategyCalibrator(ServletContext context, IStorage storage) {
        this.context = context;
        this.storage = storage;
        this.strategyNames = new ArrayList(2);
    }

    public void addStrategy(String strategyName) {
        this.strategyNames.add(strategyName);
    }

    public void progressChanged(IDemandStrategy strategy, float progress) {
        int percent = (int)(progress * 100.0f);
        String message = "Calibrating '" + strategy.getName() + "' strategy (" + percent + "%)";
        CalibrationSocket.update(this.totalProgress + percent / this.strategyNames.size(), message);
    }

    @Override
    public void run() {
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.OFF);
        StrategyBuilder builder = new StrategyBuilder(this.storage);
        int i = 0;
        while (i < this.strategyNames.size()) {
            String strategyName = this.strategyNames.get(i);
            IDemandStrategy strategy = builder.create(strategyName, false);
            this.calibrateStrategy(strategy, strategyName);
            this.totalProgress = 100 / this.strategyNames.size() * (i + 1);
            ++i;
        }
        CalibrationSocket.update(100, "");
        this.context.setAttribute("status", (Object)"started");
        logger.setLevel(Level.INFO);
    }
}

