/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.experiment;

import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.api.sockets.ResultsSocket;
import org.palladiosimulator.protocom.framework.java.ee.experiment.ExperimentData;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;

@Singleton
public final class SensorFrameworkExperiment
implements IExperiment {
    private static final Logger LOGGER = Logger.getRootLogger();
    private static final double ONE_SECOND_IN_NANO_SECONDS = Math.pow(10.0, 9.0);
    private static final String[] STATE_FILES = new String[]{"experiment.ser", "exprun.ser", "id_generator.ser", "sensor.ser"};
    @Inject
    private IStorage storage;
    private IDAOFactory dataSource;
    private Experiment experiment;
    private String experimentId;
    private String experimentName;
    private String tempFolder;
    private ExperimentRun run;
    private HashMap<String, TimeSpanSensor> sensors = new HashMap();

    @Override
    public void init(String experimentName) {
        this.experimentId = this.getExperimentId(experimentName);
        this.experimentName = experimentName;
        this.reset();
    }

    @Override
    public void reset() {
        this.sensors.clear();
        if (this.dataSource != null) {
            try {
                this.dataSource.finalizeAndClose();
            }
            catch (Exception e) {
                LOGGER.debug((Object)"Sensor Framework exception");
            }
        }
        this.tempFolder = this.getTempFolder();
        this.fetchExperiment(this.experimentId, this.tempFolder);
        this.dataSource = new FileDAOFactory(this.tempFolder);
        this.experiment = this.dataSource.createExperimentDAO().addExperiment(this.experimentName);
    }

    @Override
    public String getId() {
        return this.experimentId;
    }

    @Override
    public void startRun() {
        this.run = this.experiment.addExperimentRun(new Date().toString());
    }

    @Override
    public void stopRun() {
        String folder = "results/" + this.experimentId;
        try {
            this.storage.createFolder("results");
            this.storage.createFolder(folder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dataSource.store();
        this.storeExperiment(this.experimentId, this.tempFolder);
        ExperimentData data = new ExperimentData();
        data.setId(this.experimentId);
        data.setName(this.experimentName);
        data.setDate(new Date());
        try {
            this.storage.writeFile(String.valueOf(folder) + "/experiment.json", JsonHelper.toJson(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ResultsSocket.update(data);
    }

    @Override
    public void takeMeasurement(String name, long startTime, long endTime) {
        TimeSpanSensor sensor = this.sensors.get(name);
        if (sensor == null) {
            sensor = this.experiment.addTimeSpanSensor(name);
            this.sensors.put(name, sensor);
        }
        double start = (double)startTime / ONE_SECOND_IN_NANO_SECONDS;
        double timeSpan = (double)(endTime - startTime) / ONE_SECOND_IN_NANO_SECONDS;
        this.run.addTimeSpanMeasurement(sensor, start, timeSpan);
    }

    private String getExperimentId(String name) {
        String id = "default";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(name.getBytes("UTF-8"));
            id = new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return id;
    }

    private String fetchExperiment(String id, String destination) {
        File folder = new File(destination);
        folder.mkdirs();
        String source = "results/" + id + "/";
        if (this.storage.fileExists(source)) {
            try {
                String[] stringArray = STATE_FILES;
                int n = STATE_FILES.length;
                int n2 = 0;
                while (n2 < n) {
                    String stateFile = stringArray[n2];
                    this.copyToFs(source, stateFile, destination);
                    ++n2;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return folder.getAbsolutePath();
    }

    private void storeExperiment(String id, String source) {
        String destination = "results/" + id + "/";
        try {
            String[] stringArray = STATE_FILES;
            int n = STATE_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                String stateFile = stringArray[n2];
                this.copyFromFs(source, stateFile, destination);
                ++n2;
            }
            stringArray = new File(source).list();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (!this.storage.fileExists(String.valueOf(destination) + file)) {
                    this.copyFromFs(source, file, destination);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getTempFolder() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("java.io.tmpdir"));
        sb.append("/ProtoCom/");
        sb.append(UUID.randomUUID());
        sb.append('/');
        return sb.toString();
    }

    private void copyToFs(String path, String file, String destination) throws IOException {
        try {
            byte[] data = this.storage.readFile(String.valueOf(path) + file);
            FileOutputStream out = new FileOutputStream(String.valueOf(destination) + file);
            out.write(data);
            out.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.debug((Object)("File '" + path + file + "' not found"));
        }
    }

    private void copyFromFs(String path, String file, String destination) throws IOException {
        try {
            FileInputStream in = new FileInputStream(String.valueOf(path) + file);
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)data);
            this.storage.writeFile(String.valueOf(destination) + file, data.toByteArray());
            in.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.debug((Object)("File '" + path + file + "' not found"));
        }
    }
}

