/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.main;

import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.Set;
import javax.inject.Singleton;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;
import org.palladiosimulator.protocom.framework.java.ee.experiment.SensorFrameworkExperiment;
import org.palladiosimulator.protocom.framework.java.ee.prototype.PortServlet;
import org.palladiosimulator.protocom.framework.java.ee.storage.EcmStorage;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ProtoComModule
extends ServletModule {
    private static final String API_PACKAGE = "org.palladiosimulator.protocom.framework.java.ee.api.http";

    protected void configureServlets() {
        this.bind(IStorage.class).to(EcmStorage.class);
        this.bind(IExperiment.class).to(SensorFrameworkExperiment.class);
        this.registerApi();
        this.registerServlets();
    }

    private void registerApi() {
        PackagesResourceConfig config = new PackagesResourceConfig(new String[]{API_PACKAGE});
        for (Class resource : config.getClasses()) {
            this.bind(resource);
        }
        this.serve("/api/*", new String[0]).with(GuiceContainer.class);
    }

    private void registerServlets() {
        Reflections reflections = new Reflections("defaultrepository", new Scanner[0]);
        Set servlets = reflections.getSubTypesOf(PortServlet.class);
        for (Class servlet : servlets) {
            String name = "/" + servlet.getSimpleName();
            this.bind(servlet).in(Singleton.class);
            this.serve(name, new String[0]).with(servlet);
        }
    }
}

