/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.main;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.palladiosimulator.protocom.framework.java.ee.api.sockets.LogSocket;
import org.palladiosimulator.protocom.framework.java.ee.main.LogMessage;

public class WebAppender
extends AppenderSkeleton {
    public static final String NAME = "ProtoCom-Log";
    private static final int CAPACITY = 100;
    private static final PatternLayout LAYOUT = new PatternLayout("%d{HH:mm:ss} %p %m%n");
    private final LinkedList<LogMessage> messages = new LinkedList();

    public WebAppender() {
        this.setName(NAME);
    }

    public List<LogMessage> getLogContent() {
        return this.messages;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent event) {
        while (this.messages.size() >= 100) {
            this.messages.removeFirst();
        }
        String text = LAYOUT.format(event);
        boolean isError = event.getLevel().isGreaterOrEqual((Priority)Level.ERROR);
        LogMessage logMessage = new LogMessage(text, isError);
        this.messages.addLast(logMessage);
        LogSocket.append(logMessage);
    }
}

