/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.webcontent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.palladiosimulator.commons.eclipseutils.FileHelper;
import org.palladiosimulator.protocom.framework.java.ee.webcontent.FrameworkFile;

public class FileProvider {
    private FrameworkFile processIndex(String source, String path) {
        URL url = this.getClass().getResource("files/" + source);
        if (url == null) {
            throw new RuntimeException("Could not find file \"" + source + "\"");
        }
        String absolute = String.valueOf(path) + '/' + source.substring(source.lastIndexOf(47) + 1);
        return new FrameworkFile(url, absolute);
    }

    private FrameworkFile processPlugin(String source) {
        String target = "WEB-INF/lib/" + FileHelper.getPluginJarFileName((String)source);
        return new FrameworkFile(FileHelper.getPluginJarFile((String)source), target);
    }

    public List<FrameworkFile> getFrameworkFiles() {
        String line;
        BufferedReader reader;
        Object var4_7;
        LinkedList<FrameworkFile> files = new LinkedList<FrameworkFile>();
        try {
            Throwable throwable = null;
            var4_7 = null;
            try {
                reader = this.getReader("files.index");
                try {
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#") || line.trim().isEmpty()) continue;
                        String[] comp = line.split("->");
                        if (comp.length != 2) {
                            throw new RuntimeException("Wrong index file format");
                        }
                        files.add(this.processIndex(comp[0].trim(), comp[1].trim()));
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Throwable e = null;
            var4_7 = null;
            try {
                reader = this.getReader("libraries.index");
                try {
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#") || line.trim().isEmpty()) continue;
                        files.add(this.processPlugin(line.trim()));
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    private BufferedReader getReader(String file) {
        try {
            return new BufferedReader(new InputStreamReader(this.getClass().getResource(file).openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Index file not found", e);
        }
    }

    public void getDependencies(String pluginID, Set<String> result) {
        Bundle plugin = Platform.getBundle((String)pluginID);
        if (plugin == null) {
            return;
        }
        String requires = (String)plugin.getHeaders().get("Require-Bundle");
        String jar = "<unknown>";
        try {
            jar = FileLocator.getBundleFile((Bundle)plugin).getName();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
            if (elements != null) {
                ManifestElement[] manifestElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement element = manifestElementArray[n2];
                    String value = element.getValue();
                    result.add(String.valueOf(value) + " (" + jar + ")");
                    this.getDependencies(value, result);
                    ++n2;
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
        }
    }
}

