/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;

@Path(value="/files")
public class Files {
    @Inject
    private IStorage storage;

    private HashSet<Object> getFileSet(String path) throws IOException {
        HashSet<Object> result = new HashSet<Object>();
        Set<String> files = this.storage.getFiles(path);
        for (String file : files) {
            String name = String.valueOf(path) + "/" + file;
            if (this.storage.isFolder(name)) {
                HashMap<String, Object> folder = new HashMap<String, Object>();
                folder.put("name", file);
                folder.put("files", this.getFileSet(name));
                result.add(folder);
                continue;
            }
            result.add(file);
        }
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getFiles() {
        HashSet<Object> files = null;
        try {
            files = this.getFileSet("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Response.ok((Object)JsonHelper.toJson(files)).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getFile(@QueryParam(value="path") String path) {
        try {
            byte[] data = this.storage.readFile(path);
            return Response.ok((Object)data).build();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return Response.noContent().build();
        }
    }

    @GET
    @Path(value="delete")
    public Response deleteFile(@QueryParam(value="path") String path) {
        this.storage.deleteFile(path);
        return Response.noContent().build();
    }
}

