/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.experiment;

import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;
import org.palladiosimulator.protocom.framework.java.ee.experiment.StartTime;
import org.palladiosimulator.protocom.framework.java.ee.prototype.ICallVisitor;

@Singleton
public final class ExperimentVisitor
implements ICallVisitor {
    @Inject
    private IExperiment experiment;
    private final Stack<StartTime> startTimes = new Stack();

    @Override
    public void preCallVisit(String callId) {
        StartTime start = new StartTime(callId, System.nanoTime());
        this.startTimes.push(start);
    }

    @Override
    public void postCallVisit(String callId) {
        long now = System.nanoTime();
        StartTime start = this.startTimes.pop();
        this.experiment.takeMeasurement(callId, start.getTime(), now);
    }
}

