/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.protocol;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.palladiosimulator.protocom.framework.java.ee.protocol.LocalStub;
import org.palladiosimulator.protocom.framework.java.ee.protocol.Parameter;
import org.palladiosimulator.protocom.framework.java.ee.protocol.RegistryEntry;
import org.palladiosimulator.protocom.framework.java.ee.protocol.RegistryException;
import org.palladiosimulator.protocom.framework.java.ee.protocol.Request;
import org.palladiosimulator.protocom.framework.java.ee.protocol.StringResponse;

public final class Registry {
    private static final String REGISTRY_PATH = "/registry";
    private static Registry instance;
    private String location;

    private Registry() {
    }

    public static Registry getInstance() {
        if (instance == null) {
            instance = new Registry();
        }
        return instance;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void register(String name, Class<?>[] interfaces, String location, String path) throws RegistryException {
        RegistryEntry entry = new RegistryEntry(name, interfaces, location, path);
        ArrayList<Parameter> params = new ArrayList<Parameter>(2);
        params.add(new Parameter("action", "register"));
        params.add(new Parameter("entry", entry.toJson()));
        String responseString = Request.get(location, REGISTRY_PATH, params);
        StringResponse response = StringResponse.fromJson(responseString);
        if (response.getError() == 1) {
            throw new RegistryException("Object '" + name + "' is already registered");
        }
    }

    public void unregister(String name) throws RegistryException {
        ArrayList<Parameter> params = new ArrayList<Parameter>(2);
        params.add(new Parameter("action", "unregister"));
        params.add(new Parameter("name", name));
        String responseString = Request.get(this.location, REGISTRY_PATH, params);
        StringResponse response = StringResponse.fromJson(responseString);
        if (response.getError() == 2) {
            throw new RegistryException("Object '" + name + "' is not registered");
        }
    }

    public Object lookup(String name) throws RegistryException {
        ArrayList<Parameter> params = new ArrayList<Parameter>(2);
        params.add(new Parameter("action", "lookup"));
        params.add(new Parameter("name", name));
        String responseString = Request.get(this.location, REGISTRY_PATH, params);
        StringResponse response = StringResponse.fromJson(responseString);
        if (response.getError() != 0) {
            throw new RegistryException("Failed to look up '" + name + "' in registry");
        }
        RegistryEntry entry = RegistryEntry.fromJson(response.getPayload());
        Object stub = Proxy.newProxyInstance(entry.getInterfaces()[0].getClassLoader(), entry.getInterfaces(), (InvocationHandler)new LocalStub(entry.getLocation(), entry.getPath()));
        return stub;
    }
}

