/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import com.sun.jersey.core.header.ContentDisposition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.prototype.IUsageScenario;
import org.palladiosimulator.protocom.framework.java.ee.prototype.PrototypeBridge;

@Path(value="/scenarios")
public class Scenarios {
    @Inject
    private PrototypeBridge bridge;

    private IUsageScenario getScenario(String id) {
        IUsageScenario[] iUsageScenarioArray = this.bridge.getUsageScenarios();
        int n = iUsageScenarioArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUsageScenario scenario = iUsageScenarioArray[n2];
            if (scenario.getId().equals(id)) {
                return scenario;
            }
            ++n2;
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getScenarios() {
        return Response.ok((Object)JsonHelper.toJson(this.bridge.getUsageScenarios())).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/octet-stream"})
    public Response downloadScenario(@PathParam(value="id") String id) {
        IUsageScenario scenario = this.getScenario(id);
        if (scenario != null) {
            try {
                InputStream in = scenario.getFileUrl().openStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ContentDisposition disposition = ContentDisposition.type((String)"attachement").fileName(scenario.getFileName()).build();
                return Response.ok((Object)out.toByteArray()).header("Content-Disposition", (Object)disposition).build();
            }
            catch (IOException e) {
                e.printStackTrace();
                return Response.serverError().build();
            }
        }
        return Response.serverError().build();
    }
}

