/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.modules;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.modules.Module;
import org.palladiosimulator.protocom.framework.java.ee.modules.ModuleStartException;
import org.palladiosimulator.protocom.framework.java.ee.prototype.PrototypeBridge;
import org.palladiosimulator.protocom.framework.java.ee.prototype.StrategiesRegistry;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;

public class ContainerModule
extends Module {
    private static final Logger LOGGER = Logger.getRootLogger();
    private final PrototypeBridge.Container container;
    private final PrototypeBridge.Allocation[] allocations;

    public ContainerModule(PrototypeBridge.Container container, PrototypeBridge.Allocation[] allocations) {
        super(container.getId(), container.getName());
        this.container = container;
        this.allocations = allocations;
        this.setDisplayName("Container: " + container.getName());
    }

    @Override
    public void start(String location) throws ModuleStartException {
        if (this.isStarted()) {
            LOGGER.error((Object)("Container '" + this.getName() + "' already started"));
            throw new ModuleStartException();
        }
        LOGGER.info((Object)("Starting container '" + this.getName() + "'"));
        PrototypeBridge.Allocation[] allocationArray = this.allocations;
        int n = this.allocations.length;
        int n2 = 0;
        while (n2 < n) {
            PrototypeBridge.Allocation allocation = allocationArray[n2];
            String componentName = allocation.getComponentClass().getSimpleName();
            LOGGER.info((Object)("Starting component '" + componentName + "'"));
            try {
                Class<?> componentClass = allocation.getComponentClass();
                Class[] types = new Class[]{String.class, String.class};
                Object[] arguments = new Object[]{location, allocation.getAssemblyContext()};
                Constructor<?> constructor = componentClass.getConstructor(types);
                constructor.newInstance(arguments);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.initializeStrategies();
        this.setStarted(true);
    }

    private void initializeStrategies() {
        String hddRateExp;
        String cpuRateExp = this.container.getCpuRate();
        if (cpuRateExp.length() == 0) {
            cpuRateExp = "0";
        }
        if ((hddRateExp = this.container.getHddRate()).length() == 0) {
            hddRateExp = "0";
        }
        double cpuRate = (Double)StackContext.evaluateStatic((String)cpuRateExp, Double.class);
        double hddRate = (Double)StackContext.evaluateStatic((String)hddRateExp, Double.class);
        StrategiesRegistry registry = StrategiesRegistry.getInstance();
        IDemandStrategy cpu = registry.getStrategy(ResourceTypeEnum.CPU);
        IDemandStrategy hdd = registry.getStrategy(ResourceTypeEnum.HDD);
        cpu.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, cpuRate);
        hdd.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, hddRate);
    }
}

