/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.palladiosimulator.protocom.framework.java.ee.api.http.CalibrationThreadFactory;
import org.palladiosimulator.protocom.framework.java.ee.api.http.StrategyBuilder;
import org.palladiosimulator.protocom.framework.java.ee.api.http.StrategyCalibrator;
import org.palladiosimulator.protocom.framework.java.ee.api.http.data.OptionsData;
import org.palladiosimulator.protocom.framework.java.ee.experiment.IExperiment;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;
import org.palladiosimulator.protocom.framework.java.ee.main.MainServlet;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;

@Path(value="/options")
public class Options {
    @Context
    private ServletContext context;
    private static ExecutorService executor;
    @Inject
    private IStorage storage;
    @Inject
    private IExperiment experiment;

    static {
        CalibrationThreadFactory factory = new CalibrationThreadFactory();
        executor = Executors.newFixedThreadPool(1, factory);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getOptions() {
        String[] files;
        String optionsJson;
        try {
            optionsJson = this.storage.readFileAsString("options.json");
        }
        catch (FileNotFoundException e) {
            return Response.ok((Object)"{}").build();
        }
        try {
            Set<String> calibrated = this.storage.getFiles("calibration");
            files = calibrated.toArray(new String[0]);
        }
        catch (IOException e) {
            files = new String[]{};
        }
        OptionsData options = JsonHelper.fromJson(optionsJson, OptionsData.class);
        options.setCalibrated(files);
        return Response.ok((Object)JsonHelper.toJson(options)).build();
    }

    @POST
    public Response setOptions(String data) {
        boolean isCalibrated = true;
        OptionsData options = JsonHelper.fromJson(data, OptionsData.class);
        StrategyBuilder builder = new StrategyBuilder(this.storage);
        StrategyCalibrator calibrator = new StrategyCalibrator(this.context, this.storage);
        String cpuStrategy = "cpu." + options.getCpuStrategy();
        String hddStrategy = "hdd." + options.getHddStrategy();
        try {
            Set<String> files = this.storage.getFiles("calibration");
            if (files.contains(cpuStrategy)) {
                builder.create(cpuStrategy, true);
            } else {
                isCalibrated = false;
                calibrator.addStrategy(cpuStrategy);
            }
            if (files.contains(hddStrategy)) {
                builder.create(hddStrategy, true);
            } else {
                isCalibrated = false;
                calibrator.addStrategy(hddStrategy);
            }
        }
        catch (IOException e) {
            isCalibrated = false;
            calibrator.addStrategy(cpuStrategy);
            calibrator.addStrategy(hddStrategy);
        }
        if (isCalibrated) {
            this.context.setAttribute("status", (Object)"started");
        } else {
            this.context.setAttribute("status", (Object)"calibrating");
            executor.submit(calibrator);
        }
        this.experiment.init(options.getName());
        String seed = options.getSeed();
        if (seed.length() > 0) {
            try {
                MainServlet.setStoExSeed(Long.parseLong(options.getSeed()));
            }
            catch (NumberFormatException e) {
                MainServlet.setStoExSeed(0L);
            }
        }
        try {
            this.storage.writeFile("options.json", data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }
}

